/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.Processes;
import java.io.IOException;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class ZSystem {
    ZSystem() {
    }

    public abstract @Nullable String getProperty(@NonNull String var1);

    public abstract @NonNull Process exec(String ... var1) throws IOException;

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public String getEnv(String name) {
        return System.getenv(name);
    }

    public static @NonNull ZSystem getDefault() {
        return DefaultSystem.INSTANCE;
    }

    public static @NonNull ZSystem noOp() {
        return NoOpSystem.INSTANCE;
    }

    public static @NonNull ZSystem failing() {
        return FailingSystem.INSTANCE;
    }

    private static final class FailingSystem
    extends ZSystem {
        public static final FailingSystem INSTANCE = new FailingSystem();

        private FailingSystem() {
        }

        @Override
        public String getProperty(String key) {
            return "";
        }

        @Override
        public Process exec(String ... cmdarray) throws IOException {
            throw new IOException();
        }
    }

    private static final class NoOpSystem
    extends ZSystem {
        public static final NoOpSystem INSTANCE = new NoOpSystem();

        private NoOpSystem() {
        }

        @Override
        public String getProperty(String key) {
            return null;
        }

        @Override
        public Process exec(String ... cmdarray) throws IOException {
            return Processes.noOp();
        }
    }

    private static final class DefaultSystem
    extends ZSystem {
        public static final DefaultSystem INSTANCE = new DefaultSystem();

        private DefaultSystem() {
        }

        @Override
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public Process exec(String ... cmdarray) throws IOException {
            return Runtime.getRuntime().exec(cmdarray);
        }
    }
}

