/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public enum DesktopFactoryProc implements UnaryOperator<Stream<Desktop.Factory>>
{
    INSTANCE;


    @Override
    public Stream<Desktop.Factory> apply(Stream<Desktop.Factory> t) {
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return t.map(o -> new AbstractMap.SimpleEntry<Desktop.Factory.SupportType, Desktop.Factory>(o.getSupportType(osArch, osName, osVersion), (Desktop.Factory)o)).filter(DesktopFactoryProc::isSupported).sorted(DesktopFactoryProc::compareByLevelOfSupport).map(Map.Entry::getValue);
    }

    private static boolean isSupported(Map.Entry<Desktop.Factory.SupportType, Desktop.Factory> entry) {
        return !entry.getKey().equals((Object)Desktop.Factory.SupportType.NONE);
    }

    private static int compareByLevelOfSupport(Map.Entry<Desktop.Factory.SupportType, Desktop.Factory> l, Map.Entry<Desktop.Factory.SupportType, Desktop.Factory> r) {
        return r.getKey().compareTo(l.getKey());
    }
}

