/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.EnumMap;
import java.util.Map;
import lombok.NonNull;

public class MailtoBuilder {
    protected final EnumMap<HName, String> map = new EnumMap(HName.class);

    @NonNull
    public MailtoBuilder to(String ... emails) {
        if (emails == null) {
            throw new NullPointerException("emails is marked non-null but is null");
        }
        this.map.put(HName.TO, MailtoBuilder.join(emails));
        return this;
    }

    @NonNull
    public MailtoBuilder cc(String ... emails) {
        if (emails == null) {
            throw new NullPointerException("emails is marked non-null but is null");
        }
        this.map.put(HName.CC, MailtoBuilder.join(emails));
        return this;
    }

    @NonNull
    public MailtoBuilder bcc(String ... emails) {
        if (emails == null) {
            throw new NullPointerException("emails is marked non-null but is null");
        }
        this.map.put(HName.BCC, MailtoBuilder.join(emails));
        return this;
    }

    @NonNull
    public MailtoBuilder subject(@NonNull String subject) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        this.map.put(HName.SUBJECT, subject);
        return this;
    }

    @NonNull
    public MailtoBuilder body(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        this.map.put(HName.BODY, body);
        return this;
    }

    @NonNull
    public MailtoBuilder clear() {
        this.map.clear();
        return this;
    }

    @NonNull
    public URI build() {
        StringBuilder sb = new StringBuilder("mailto:?");
        boolean first = true;
        for (Map.Entry<HName, String> o : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(o.getKey().toString().toLowerCase()).append("=").append(MailtoBuilder.encodex(o.getValue()));
        }
        return URI.create(sb.toString());
    }

    @NonNull
    static String join(String ... list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (list.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(list[0]);
        for (int i = 1; i < list.length; ++i) {
            result.append(", ").append(list[i]);
        }
        return result.toString();
    }

    static String encodex(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8").replaceAll("\\+", "%20").replaceAll("%0A", "%0D%0A");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static enum HName {
        TO,
        CC,
        BCC,
        SUBJECT,
        BODY;

    }
}

