/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.Util;
import ec.util.desktop.impl.WinScriptHost;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class WinSearch {
    @Generated
    private static final Logger log = Logger.getLogger(WinSearch.class.getName());

    WinSearch() {
    }

    @NonNull
    public File[] search(@NonNull String query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        List<File> result = this.getFilesByName(query);
        return result.toArray(new File[0]);
    }

    @NonNull
    public abstract List<File> getFilesByName(@NonNull String var1) throws IOException;

    @NonNull
    public static WinSearch noOp() {
        return NoOpSearch.INSTANCE;
    }

    @NonNull
    public static WinSearch getDefault() {
        return LazyHolder.INSTANCE;
    }

    @NonNull
    static WinSearch failing() {
        return FailingSearch.INSTANCE;
    }

    private static final class NoOpSearch
    extends WinSearch {
        private static final WinSearch INSTANCE = new NoOpSearch();

        private NoOpSearch() {
        }

        @Override
        @NonNull
        public List<File> getFilesByName(@NonNull String query) throws IOException {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            return Collections.emptyList();
        }
    }

    private static final class LazyHolder {
        private static final WinSearch INSTANCE = LazyHolder.createInstance();

        private LazyHolder() {
        }

        private static WinSearch createInstance() {
            File searchScript = LazyHolder.extractSearchScript();
            if (searchScript != null) {
                log.log(Level.INFO, "Using VbsSearch");
                return new VbsSearch(WinScriptHost.getDefault(), searchScript);
            }
            log.log(Level.INFO, "Using NoOpSearch");
            return WinSearch.noOp();
        }

        private static @Nullable File extractSearchScript() {
            try {
                return Util.extractResource("winsearch.vbs", "winsearch", ".vbs");
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Cannot load search script", ex);
                return null;
            }
        }
    }

    private static final class FailingSearch
    extends WinSearch {
        public static final FailingSearch INSTANCE = new FailingSearch();

        private FailingSearch() {
        }

        @Override
        @NonNull
        public List<File> getFilesByName(@NonNull String query) throws IOException {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            throw new IOException();
        }
    }

    static final class VbsSearch
    extends WinSearch {
        private static final String QUOTE = "\"";
        private final WinScriptHost wsh;
        private final File searchScript;

        public VbsSearch(@NonNull WinScriptHost wsh, @NonNull File searchScript) {
            if (wsh == null) {
                throw new NullPointerException("wsh is marked non-null but is null");
            }
            if (searchScript == null) {
                throw new NullPointerException("searchScript is marked non-null but is null");
            }
            this.wsh = wsh;
            this.searchScript = searchScript;
        }

        @Override
        @NonNull
        public List<File> getFilesByName(@NonNull String query) throws IOException {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            String quotedQuery = VbsSearch.quote(query.replace(QUOTE, ""));
            Process p = this.wsh.exec(this.searchScript, quotedQuery);
            return Util.toList(p, Charset.defaultCharset(), File::new);
        }

        @NonNull
        private static String quote(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            return QUOTE + input + QUOTE;
        }
    }
}

