/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import ec.util.desktop.impl.AwtDesktop;
import ec.util.desktop.impl.Util;
import ec.util.desktop.impl.ZSystem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MacDesktop
extends AwtDesktop {
    static final String DESKTOP_DIR = "Desktop";
    static final String DOCUMENTS_DIR = "Documents";
    static final String DOWNLOAD_DIR = "Downloads";
    static final String MUSIC_DIR = "Music";
    static final String PICTURES_DIR = "Pictures";
    static final String PUBLICSHARE_DIR = "Public";
    static final String VIDEOS_DIR = "Movies";
    @NonNull
    private final ZSystem system;

    MacDesktop(@NonNull ZSystem system) {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        this.system = system;
    }

    @Override
    public boolean isSupported(@NonNull Desktop.Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        switch (action) {
            case SHOW_IN_FOLDER: {
                return true;
            }
            case SEARCH: {
                return true;
            }
        }
        return super.isSupported(action);
    }

    @Override
    public void showInFolder(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Util.checkFileValidation(file);
        this.system.exec("open", "-R", file.getAbsolutePath());
    }

    @Override
    public File getKnownFolder(@NonNull Desktop.KnownFolder userDir) {
        if (userDir == null) {
            throw new NullPointerException("userDir is marked non-null but is null");
        }
        switch (userDir) {
            case DESKTOP: {
                return MacDesktop.getKnownFolderByName(this.system, DESKTOP_DIR);
            }
            case DOCUMENTS: {
                return MacDesktop.getKnownFolderByName(this.system, DOCUMENTS_DIR);
            }
            case DOWNLOAD: {
                return MacDesktop.getKnownFolderByName(this.system, DOWNLOAD_DIR);
            }
            case MUSIC: {
                return MacDesktop.getKnownFolderByName(this.system, MUSIC_DIR);
            }
            case PICTURES: {
                return MacDesktop.getKnownFolderByName(this.system, PICTURES_DIR);
            }
            case PUBLICSHARE: {
                return MacDesktop.getKnownFolderByName(this.system, PUBLICSHARE_DIR);
            }
            case TEMPLATES: {
                return null;
            }
            case VIDEOS: {
                return MacDesktop.getKnownFolderByName(this.system, VIDEOS_DIR);
            }
        }
        return null;
    }

    @Override
    public File[] search(@NonNull String query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        String quotedQuery = "\"" + query.replace("\"", "") + "\"";
        Process p = this.system.exec("mdfind", quotedQuery);
        return Util.toFiles(p, Charset.defaultCharset());
    }

    private static @Nullable File getKnownFolderByName(@NonNull ZSystem system, @NonNull String osxFolderName) {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        if (osxFolderName == null) {
            throw new NullPointerException("osxFolderName is marked non-null but is null");
        }
        File result = new File(system.getProperty("user.home"), osxFolderName);
        return result.exists() ? result : null;
    }

    public static class Factory
    implements Desktop.Factory {
        @Override
        public @NonNull Desktop.Factory.SupportType getSupportType(String osArch, String osName, String osVersion) {
            return osName.equals("Mac OS X") || osName.startsWith("Darwin") ? Desktop.Factory.SupportType.GENERIC : Desktop.Factory.SupportType.NONE;
        }

        @Override
        @NonNull
        public Desktop create(String osArch, String osName, String osVersion) {
            return new MacDesktop(ZSystem.getDefault());
        }
    }
}

