/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop;

import ec.util.desktop.Desktop;
import ec.util.desktop.NoOpDesktop;
import ec.util.desktop.impl.DesktopFactoryLoader;
import ec.util.desktop.impl.DesktopFactoryProc;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;

public final class DesktopManager {
    private static final Logger LOGGER = Logger.getLogger(DesktopManager.class.getName());
    private static Desktop DESKTOP;

    @NonNull
    public static synchronized Desktop get() {
        if (DESKTOP == null) {
            try {
                DESKTOP = DesktopManager.load(new DesktopFactoryLoader().get());
            }
            catch (ServiceConfigurationError ex) {
                LOGGER.log(Level.SEVERE, "While loading factories", ex);
                DESKTOP = new NoOpDesktop();
            }
        }
        return DESKTOP;
    }

    public static synchronized void set(@NonNull Desktop newDesktop) {
        DESKTOP = Objects.requireNonNull(newDesktop, "desktop");
    }

    @Deprecated
    @NonNull
    public static Desktop load(@NonNull Iterable<? extends Desktop.Factory> factories) {
        Objects.requireNonNull(factories, "factories");
        Stream<Desktop.Factory> stream = StreamSupport.stream(factories.spliterator(), false).map(Desktop.Factory.class::cast);
        return DesktopManager.load(DesktopFactoryProc.INSTANCE.apply(stream).findFirst());
    }

    private static Desktop load(Optional<Desktop.Factory> bestFactory) {
        if (!bestFactory.isPresent()) {
            LOGGER.info("No factories found");
            return new NoOpDesktop();
        }
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        LOGGER.log(Level.INFO, "Using factory ''{0}''", bestFactory.get().getClass().getName());
        return bestFactory.get().create(osArch, osName, osVersion);
    }

    private DesktopManager() {
    }
}

