/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.AwtDesktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

final class Util {
    public static final SortedMap<String, Object> EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());

    private Util() {
    }

    public static boolean isClassAvailable(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean is64bit() {
        return "amd64".equals(System.getProperty("os.arch"));
    }

    public static @Nullable File fileFromPathname(@Nullable String pathname) {
        try {
            return pathname != null && !pathname.isEmpty() ? Paths.get(pathname, new String[0]).toFile() : null;
        }
        catch (InvalidPathException ex) {
            return null;
        }
    }

    @NonNull
    public static File checkFileValidation(@NonNull File file) throws NullPointerException, IllegalArgumentException, SecurityException {
        Objects.requireNonNull(file, "File must not be null");
        if (!file.exists()) {
            throw new IllegalArgumentException("The file: " + file.getPath() + " doesn't exist.");
        }
        file.canRead();
        return file;
    }

    @NonNull
    public static File extractResource(@NonNull String resourceName, @NonNull String filePrefix, @NonNull String fileSuffix) throws IOException {
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        if (filePrefix == null) {
            throw new NullPointerException("filePrefix is marked non-null but is null");
        }
        if (fileSuffix == null) {
            throw new NullPointerException("fileSuffix is marked non-null but is null");
        }
        File result = File.createTempFile(filePrefix, fileSuffix);
        result.deleteOnExit();
        try (InputStream in = AwtDesktop.class.getResourceAsStream(resourceName);){
            Files.copy(in, result.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return result;
    }

    @NonNull
    public static File[] toFiles(@NonNull Process p, @NonNull Charset charset) throws IOException {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        List<File> result = Util.toList(p, charset, File::new);
        return result.toArray(new File[0]);
    }

    @NonNull
    public static <T> List<T> toList(@NonNull Process p, @NonNull Charset charset, @NonNull Function<String, T> func) throws IOException {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<T> result = new ArrayList<T>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(func.apply(line));
            }
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }
}

