/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.RegRegistry;
import ec.util.desktop.impl.Util;
import java.io.IOException;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class WinRegistry {
    @Generated
    private static final Logger log = Logger.getLogger(WinRegistry.class.getName());

    public abstract boolean keyExists(@NonNull Root var1, @NonNull String var2) throws IOException;

    public abstract @Nullable Object getValue(@NonNull Root var1, @NonNull String var2, @NonNull String var3) throws IOException;

    @NonNull
    public abstract SortedMap<String, Object> getValues(@NonNull Root var1, @NonNull String var2) throws IOException;

    @NonNull
    public static WinRegistry noOp() {
        return NoOpRegistry.INSTANCE;
    }

    @NonNull
    public static WinRegistry failing() {
        return FailingRegistry.INSTANCE;
    }

    @NonNull
    public static WinRegistry getDefault() {
        return LazyHolder.INSTANCE;
    }

    private static final class NoOpRegistry
    extends WinRegistry {
        public static final NoOpRegistry INSTANCE = new NoOpRegistry();

        private NoOpRegistry() {
        }

        @Override
        public boolean keyExists(@NonNull Root root, @NonNull String key) throws IOException {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            return false;
        }

        @Override
        public Object getValue(@NonNull Root root, @NonNull String key, @NonNull String name) throws IOException {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            return null;
        }

        @Override
        @NonNull
        public SortedMap<String, Object> getValues(@NonNull Root root, @NonNull String key) throws IOException {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            return Util.EMPTY_SORTED_MAP;
        }
    }

    private static final class FailingRegistry
    extends WinRegistry {
        public static final FailingRegistry INSTANCE = new FailingRegistry();

        private FailingRegistry() {
        }

        @Override
        public boolean keyExists(@NonNull Root root, @NonNull String key) throws IOException {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            throw new IOException();
        }

        @Override
        public Object getValue(@NonNull Root root, @NonNull String key, @NonNull String name) throws IOException {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            throw new IOException();
        }

        @Override
        @NonNull
        public SortedMap<String, Object> getValues(@NonNull Root root, @NonNull String key) throws IOException {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            throw new IOException();
        }
    }

    private static final class LazyHolder {
        private static final WinRegistry INSTANCE = LazyHolder.createInstance();

        private LazyHolder() {
        }

        private static WinRegistry createInstance() {
            log.log(Level.INFO, "Using RegRegistry");
            return new RegRegistry();
        }
    }

    public static enum Root {
        HKEY_LOCAL_MACHINE,
        HKEY_CURRENT_USER;

    }
}

