/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.Processes;
import ec.util.desktop.impl.ZSystem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Locale;
import lombok.NonNull;

public abstract class WinScriptHost {
    public abstract boolean canExec(@NonNull File var1);

    public abstract boolean canExec(@NonNull String var1, @NonNull String var2);

    @NonNull
    public abstract Process exec(@NonNull File var1, String ... var2) throws IOException;

    @NonNull
    public abstract Process exec(@NonNull String var1, @NonNull String var2, String ... var3) throws IOException;

    @NonNull
    public static WinScriptHost noOp() {
        return NoOpScriptHost.INSTANCE;
    }

    @NonNull
    public static WinScriptHost failing() {
        return FailingScriptHost.INSTANCE;
    }

    @NonNull
    public static WinScriptHost getDefault() {
        return LazyHolder.INSTANCE;
    }

    private static final class NoOpScriptHost
    extends WinScriptHost {
        public static final NoOpScriptHost INSTANCE = new NoOpScriptHost();

        private NoOpScriptHost() {
        }

        @Override
        public boolean canExec(@NonNull File script) {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            return false;
        }

        @Override
        public boolean canExec(@NonNull String script, @NonNull String language) {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            if (language == null) {
                throw new NullPointerException("language is marked non-null but is null");
            }
            return false;
        }

        @Override
        @NonNull
        public Process exec(@NonNull File script, String ... args) throws IOException {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            return Processes.noOp();
        }

        @Override
        @NonNull
        public Process exec(@NonNull String script, @NonNull String language, String ... args) throws IOException {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            if (language == null) {
                throw new NullPointerException("language is marked non-null but is null");
            }
            return Processes.noOp();
        }
    }

    private static final class FailingScriptHost
    extends WinScriptHost {
        public static final FailingScriptHost INSTANCE = new FailingScriptHost();

        private FailingScriptHost() {
        }

        @Override
        public boolean canExec(@NonNull File script) {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            return true;
        }

        @Override
        public boolean canExec(@NonNull String script, @NonNull String language) {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            if (language == null) {
                throw new NullPointerException("language is marked non-null but is null");
            }
            return true;
        }

        @Override
        @NonNull
        public Process exec(@NonNull File script, String ... args) throws IOException {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            throw new IOException();
        }

        @Override
        @NonNull
        public Process exec(@NonNull String script, @NonNull String language, String ... args) throws IOException {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            if (language == null) {
                throw new NullPointerException("language is marked non-null but is null");
            }
            throw new IOException();
        }
    }

    private static final class LazyHolder {
        private static final WinScriptHost INSTANCE = LazyHolder.createInstance();

        private LazyHolder() {
        }

        private static WinScriptHost createInstance() {
            ZSystem system = ZSystem.getDefault();
            return LazyHolder.isWindows(system) ? new CScript(system) : WinScriptHost.noOp();
        }

        private static boolean isWindows(ZSystem system) {
            String osName = system.getProperty("os.name");
            return osName != null && osName.startsWith("Windows ");
        }
    }

    private static final class CScript
    extends WinScriptHost {
        private final ZSystem system;

        CScript(@NonNull ZSystem system) {
            if (system == null) {
                throw new NullPointerException("system is marked non-null but is null");
            }
            this.system = system;
        }

        @Override
        public boolean canExec(@NonNull File script) {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            return script.exists() && script.isFile() && script.canRead() && Language.getByExtension(script) != Language.UNKNOWN;
        }

        @Override
        public boolean canExec(@NonNull String script, @NonNull String language) {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            if (language == null) {
                throw new NullPointerException("language is marked non-null but is null");
            }
            return Language.getByName(language) != Language.UNKNOWN;
        }

        @Override
        @NonNull
        public Process exec(@NonNull File script, String ... args) throws IOException {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            String[] result = new String[3 + args.length];
            result[0] = "cscript";
            result[1] = "/nologo";
            result[2] = "\"" + script.getAbsolutePath() + "\"";
            System.arraycopy(args, 0, result, 3, args.length);
            return this.system.exec(result);
        }

        @Override
        @NonNull
        public Process exec(@NonNull String script, @NonNull String language, String ... args) throws IOException {
            if (script == null) {
                throw new NullPointerException("script is marked non-null but is null");
            }
            if (language == null) {
                throw new NullPointerException("language is marked non-null but is null");
            }
            File file = File.createTempFile("script", Language.getByName(language).getExtension());
            file.deleteOnExit();
            Files.write(file.toPath(), Collections.singleton(script), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            return this.exec(file, args);
        }

        private static enum Language {
            VBSCRIPT,
            JSCRIPT,
            UNKNOWN;


            public String getExtension() throws IOException {
                switch (this.ordinal()) {
                    case 0: {
                        return ".vbs";
                    }
                    case 1: {
                        return ".js";
                    }
                }
                throw new IOException("Unsupported language");
            }

            public static Language getByName(String input) {
                switch (input) {
                    case "VBScript": {
                        return VBSCRIPT;
                    }
                    case "JScript": {
                        return JSCRIPT;
                    }
                }
                return UNKNOWN;
            }

            public static Language getByExtension(File file) {
                String fileName = file.getName().toLowerCase(Locale.ROOT);
                if (fileName.endsWith(".vbs")) {
                    return VBSCRIPT;
                }
                if (fileName.endsWith(".js")) {
                    return JSCRIPT;
                }
                return UNKNOWN;
            }
        }
    }
}

