/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import ec.util.desktop.impl.AwtDesktop;
import ec.util.desktop.impl.Util;
import ec.util.desktop.impl.XdgConfig;
import ec.util.desktop.impl.ZSystem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class XdgDesktop
extends AwtDesktop {
    private static final Logger LOGGER = Logger.getLogger(XdgDesktop.class.getName());
    static final String DESKTOP_DIR = "XDG_DESKTOP_DIR";
    static final String DOCUMENTS_DIR = "XDG_DOCUMENTS_DIR";
    static final String DOWNLOAD_DIR = "XDG_DOWNLOAD_DIR";
    static final String MUSIC_DIR = "XDG_MUSIC_DIR";
    static final String PICTURES_DIR = "XDG_PICTURES_DIR";
    static final String PUBLICSHARE_DIR = "XDG_PUBLICSHARE_DIR";
    static final String TEMPLATES_DIR = "XDG_TEMPLATES_DIR";
    static final String VIDEOS_DIR = "XDG_VIDEOS_DIR";
    @NonNull
    private final ZSystem system;
    @NonNull
    private final XdgConfig config;

    XdgDesktop(@NonNull ZSystem system, @NonNull XdgConfig config) {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.system = system;
        this.config = config;
    }

    @Override
    public boolean isSupported(@NonNull Desktop.Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        switch (action) {
            case SHOW_IN_FOLDER: {
                return super.isSupported(action);
            }
            case SEARCH: {
                return true;
            }
        }
        return super.isSupported(action);
    }

    @Override
    public File getKnownFolder(@NonNull Desktop.KnownFolder userDir) {
        if (userDir == null) {
            throw new NullPointerException("userDir is marked non-null but is null");
        }
        switch (userDir) {
            case DESKTOP: {
                return this.getKnownFolderByName(DESKTOP_DIR);
            }
            case DOCUMENTS: {
                return this.getKnownFolderByName(DOCUMENTS_DIR);
            }
            case DOWNLOAD: {
                return this.getKnownFolderByName(DOWNLOAD_DIR);
            }
            case MUSIC: {
                return this.getKnownFolderByName(MUSIC_DIR);
            }
            case PICTURES: {
                return this.getKnownFolderByName(PICTURES_DIR);
            }
            case PUBLICSHARE: {
                return this.getKnownFolderByName(PUBLICSHARE_DIR);
            }
            case TEMPLATES: {
                return this.getKnownFolderByName(TEMPLATES_DIR);
            }
            case VIDEOS: {
                return this.getKnownFolderByName(VIDEOS_DIR);
            }
        }
        return null;
    }

    private @Nullable File getKnownFolderByName(@NonNull String xdgFolderName) {
        if (xdgFolderName == null) {
            throw new NullPointerException("xdgFolderName is marked non-null but is null");
        }
        File result = Util.fileFromPathname(this.system.getEnv(xdgFolderName));
        return result != null ? result : Util.fileFromPathname(this.config.get(xdgFolderName));
    }

    @Override
    public File[] search(@NonNull String query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        Process p = this.system.exec("locate", "-i", query);
        return Util.toFiles(p, Charset.defaultCharset());
    }

    @NonNull
    private static XdgConfig parseConfigFile(ZSystem system) {
        try {
            return XdgConfig.getInstance(system);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "While parsing config file", ex);
            return XdgConfig.noOp();
        }
    }

    public static class Factory
    implements Desktop.Factory {
        @Override
        public @NonNull Desktop.Factory.SupportType getSupportType(String osArch, String osName, String osVersion) {
            return osName.endsWith("Linux") ? Desktop.Factory.SupportType.GENERIC : Desktop.Factory.SupportType.NONE;
        }

        @Override
        @NonNull
        public Desktop create(String osArch, String osName, String osVersion) {
            ZSystem system = ZSystem.getDefault();
            return new XdgDesktop(system, XdgDesktop.parseConfigFile(system));
        }
    }
}

