/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.Processes;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

abstract class ZSystem {
    ZSystem() {
    }

    public abstract @Nullable String getProperty(@NonNull String var1);

    @NonNull
    public abstract Process exec(String ... var1) throws IOException;

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public String getEnv(String name) {
        return System.getenv(name);
    }

    @NonNull
    public static ZSystem getDefault() {
        return DefaultSystem.INSTANCE;
    }

    @NonNull
    public static ZSystem noOp() {
        return NoOpSystem.INSTANCE;
    }

    @NonNull
    public static ZSystem failing() {
        return FailingSystem.INSTANCE;
    }

    private static final class DefaultSystem
    extends ZSystem {
        public static final DefaultSystem INSTANCE = new DefaultSystem();

        private DefaultSystem() {
        }

        @Override
        public String getProperty(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            return System.getProperty(key);
        }

        @Override
        @NonNull
        public Process exec(String ... cmdarray) throws IOException {
            return Runtime.getRuntime().exec(cmdarray);
        }
    }

    private static final class NoOpSystem
    extends ZSystem {
        public static final NoOpSystem INSTANCE = new NoOpSystem();

        private NoOpSystem() {
        }

        @Override
        public String getProperty(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            return null;
        }

        @Override
        @NonNull
        public Process exec(String ... cmdarray) throws IOException {
            return Processes.noOp();
        }
    }

    private static final class FailingSystem
    extends ZSystem {
        public static final FailingSystem INSTANCE = new FailingSystem();

        private FailingSystem() {
        }

        @Override
        public String getProperty(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            return "";
        }

        @Override
        @NonNull
        public Process exec(String ... cmdarray) throws IOException {
            throw new IOException();
        }
    }
}

