/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractAutoCompletion<C> {
    public static final String AUTO_FOCUS_PROPERTY = "autoFocus";
    public static final String DELAY_PROPERTY = "delay";
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String MIN_LENGTH_PROPERTY = "minLength";
    public static final String SOURCE_PROPERTY = "source";
    public static final String SEPARATOR_PROPERTY = "separator";
    protected final boolean DEFAULT_AUTO_FOCUS = false;
    protected final int DEFAULT_DELAY = 300;
    protected final boolean DEFAULT_ENABLED = true;
    protected final int DEFAULT_MIN_LENGTH = 1;
    protected final AutoCompletionSource DEFAULT_SOURCE = AutoCompletionSources.empty();
    protected final String DEFAULT_SEPARATOR = "";
    protected boolean autoFocus = false;
    protected int delay = 300;
    protected boolean enabled = true;
    protected int minLength = 1;
    protected AutoCompletionSource source = this.DEFAULT_SOURCE;
    protected String separator = "";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        boolean old = this.autoFocus;
        this.autoFocus = autoFocus;
        this.firePropertyChange(AUTO_FOCUS_PROPERTY, old, this.autoFocus);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        int old = this.delay;
        this.delay = delay >= 0 ? delay : 300;
        this.firePropertyChange(DELAY_PROPERTY, old, this.delay);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean old = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange(ENABLED_PROPERTY, old, this.enabled);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        int old = this.minLength;
        this.minLength = minLength >= 0 ? minLength : 1;
        this.firePropertyChange(MIN_LENGTH_PROPERTY, old, this.minLength);
    }

    public AutoCompletionSource getSource() {
        return this.source;
    }

    public void setSource(AutoCompletionSource source) {
        AutoCompletionSource old = this.source;
        this.source = source != null ? source : this.DEFAULT_SOURCE;
        this.firePropertyChange(SOURCE_PROPERTY, old, this.source);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        String old = this.separator;
        this.separator = separator != null ? separator : "";
        this.firePropertyChange(SEPARATOR_PROPERTY, old, this.separator);
    }

    public abstract void close();

    public abstract void search(@NonNull String var1);

    protected abstract @NonNull InputView<? extends C> getInputView();

    protected abstract @NonNull SearchView<? extends C> getSearchView();

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected <P> void firePropertyChange(String name, P oldValue, P newValue) {
        this.support.firePropertyChange(name, oldValue, newValue);
    }

    protected void hide() {
        this.getInputView().requestEditing();
        this.close();
    }

    protected void insertCurrent() {
        Object selectedValue = this.getSearchView().getSelectedValue();
        if (selectedValue != null) {
            String str = this.source.toString(selectedValue);
            this.getInputView().setTerm(str);
            this.getInputView().requestEditing();
            this.close();
        }
    }

    protected void selectPrev() {
        this.getSearchView().moveSelection(-1, false);
    }

    protected void selectNext() {
        this.getSearchView().moveSelection(1, false);
    }

    protected void search() {
        this.search(this.getInputView().getTerm());
    }

    public static interface SearchView<C> {
        public void onClose();

        public void onSearchStarted(@NonNull String var1);

        public void onSearchFailed(@NonNull String var1, @NonNull Exception var2);

        public void onSearchDone(@NonNull String var1, @NonNull List<?> var2);

        public void moveSelection(int var1, boolean var2);

        public @Nullable Object getSelectedValue();

        public @NonNull C getComponent();
    }

    public static interface InputView<C> {
        public boolean isEditing();

        public void requestEditing();

        public @NonNull String getTerm();

        public void setTerm(@NonNull String var1);

        public @NonNull C getComponent();
    }
}

