/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.ExtAutoCompletionSource;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AutoCompletionSources {
    private static final AutoCompletionSource NONE = ExtAutoCompletionSource.builder(() -> Collections.emptyList()).behavior(AutoCompletionSource.Behavior.NONE).build();

    private AutoCompletionSources() {
    }

    public static @NonNull AutoCompletionSource empty() {
        return NONE;
    }

    public static <T> @NonNull AutoCompletionSource of(boolean strict, T ... list) {
        return AutoCompletionSources.of(strict, Arrays.asList(list));
    }

    public static <T> @NonNull AutoCompletionSource of(boolean strict, @NonNull Iterable<T> list) {
        UnaryOperator normalizer = strict ? UnaryOperator.identity() : AutoCompletionSources::normalize;
        return ExtAutoCompletionSource.builder(term -> {
            String normalizedTerm = (String)normalizer.apply(term);
            return StreamSupport.stream(list.spliterator(), false).filter(o -> o != null && ((String)normalizer.apply(o.toString())).contains(normalizedTerm)).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        }).behavior(AutoCompletionSource.Behavior.SYNC).valueToString(Object::toString).build();
    }

    public static @NonNull String removeDiacritics(@NonNull String input) {
        return Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static @NonNull String normalize(@NonNull String input) {
        return AutoCompletionSources.removeDiacritics(input).toLowerCase();
    }
}

