/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ExtAutoCompletionSource
implements AutoCompletionSource {
    public abstract @NonNull Request getRequest(@NonNull String var1);

    public static @NonNull Request wrap(@NonNull AutoCompletionSource source, @NonNull String term) {
        Objects.requireNonNull(source);
        return new BasicRequest(term, () -> source.getBehavior(term), () -> source.getValues(term));
    }

    public static <T> @NonNull Builder<T> builder(@NonNull Callable<List<T>> supplier) {
        return ExtAutoCompletionSource.builder((String o) -> (List)supplier.call());
    }

    public static <T> @NonNull Builder<T> builder(@NonNull Loader<T> loader) {
        return new BuilderImpl<T>(loader);
    }

    public static @NonNull Predicate<String> basicFilter(@NonNull String term) {
        String normalizedTerm = AutoCompletionSources.normalize(term);
        return value -> value != null && !value.isEmpty() && AutoCompletionSources.normalize(value).contains(normalizedTerm);
    }

    private static final class CachedExtAutoCompletionSource<T>
    extends ExtAutoCompletionSource {
        private final Loader<T> loader;
        private final BiFunction<List<T>, String, List<T>> processor;
        private final Function<? super String, AutoCompletionSource.Behavior> behavior;
        private final Function<T, String> toString;
        private final ConcurrentMap cache;
        private final Function<? super String, Object> toKey;
        private final Function<? super String, AutoCompletionSource.Behavior> cacheBehavior;

        public CachedExtAutoCompletionSource(Loader<T> loader, BiFunction<List<T>, String, List<T>> consumer, Function<? super String, AutoCompletionSource.Behavior> behavior, Function<T, String> toString, ConcurrentMap cache, Function<? super String, Object> toKey, Function<? super String, AutoCompletionSource.Behavior> cacheBehavior) {
            this.loader = loader;
            this.processor = consumer;
            this.behavior = behavior;
            this.toString = toString;
            this.cache = cache;
            this.toKey = toKey;
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public Request getRequest(String term) {
            Object key = this.toKey.apply(term);
            List values = (List)this.cache.get(key);
            if (values == null) {
                return new BasicRequest(term, () -> this.behavior.apply(term), () -> {
                    List<T> data = this.loader.load(term);
                    this.cache.put(key, data);
                    return this.processor.apply(data, term);
                });
            }
            return new BasicRequest(term, () -> this.cacheBehavior.apply(term), () -> this.processor.apply(values, term));
        }

        @Override
        public AutoCompletionSource.Behavior getBehavior(String term) {
            return this.behavior.apply(term);
        }

        @Override
        public String toString(Object value) {
            return this.toString.apply(value);
        }

        @Override
        public List<?> getValues(String term) throws Exception {
            Object key = this.toKey.apply(term);
            List<T> values = (List<T>)this.cache.get(key);
            if (values == null) {
                values = this.loader.load(term);
                this.cache.put(key, values);
            }
            return this.processor.apply(values, term);
        }
    }

    private static final class DefaultExtAutoCompletionSource<T>
    extends ExtAutoCompletionSource {
        private final Loader<T> loader;
        private final BiFunction<List<T>, String, List<T>> processor;
        private final Function<? super String, AutoCompletionSource.Behavior> behavior;
        private final Function<T, String> toString;

        public DefaultExtAutoCompletionSource(Loader<T> loader, BiFunction<List<T>, String, List<T>> consumer, Function<? super String, AutoCompletionSource.Behavior> behavior, Function<T, String> toString) {
            this.loader = loader;
            this.processor = consumer;
            this.behavior = behavior;
            this.toString = toString;
        }

        @Override
        public Request getRequest(String term) {
            return new BasicRequest(term, () -> this.behavior.apply(term), () -> this.processor.apply(this.loader.load(term), term));
        }

        @Override
        public AutoCompletionSource.Behavior getBehavior(String term) {
            return this.behavior.apply(term);
        }

        @Override
        public String toString(Object value) {
            return this.toString.apply(value);
        }

        @Override
        public List<?> getValues(String term) throws Exception {
            return this.processor.apply(this.loader.load(term), term);
        }
    }

    private static final class BuilderImpl<T>
    implements Builder<T> {
        private final Loader<T> loader;
        private BiFunction<List<T>, String, List<T>> processor;
        private Function<? super String, AutoCompletionSource.Behavior> behavior;
        private Function<T, String> toString;
        private ConcurrentMap cache;
        private Function<? super String, Object> toKey;
        private Function<? super String, AutoCompletionSource.Behavior> cacheBehavior;

        public BuilderImpl(Loader<T> loader) {
            this.loader = loader;
            this.processor = (values, term) -> values;
            this.behavior = o -> AutoCompletionSource.Behavior.ASYNC;
            this.toString = Object::toString;
            this.cache = null;
            this.toKey = null;
            this.cacheBehavior = null;
        }

        @Override
        public Builder<T> postProcessor(BiFunction<List<T>, String, List<T>> processor) {
            this.processor = Objects.requireNonNull(processor);
            return this;
        }

        @Override
        public Builder<T> behavior(Function<? super String, AutoCompletionSource.Behavior> behavior) {
            this.behavior = Objects.requireNonNull(behavior);
            return this;
        }

        @Override
        public Builder<T> valueToString(Function<T, String> toString) {
            this.toString = Objects.requireNonNull(toString);
            return this;
        }

        @Override
        public Builder<T> cache(ConcurrentMap cache, Function<? super String, Object> toKey, Function<? super String, AutoCompletionSource.Behavior> behavior) {
            this.cache = Objects.requireNonNull(cache);
            this.toKey = Objects.requireNonNull(toKey);
            this.cacheBehavior = Objects.requireNonNull(behavior);
            return this;
        }

        @Override
        public ExtAutoCompletionSource build() {
            return this.cache != null ? new CachedExtAutoCompletionSource<T>(this.loader, this.processor, this.behavior, this.toString, this.cache, this.toKey, this.cacheBehavior) : new DefaultExtAutoCompletionSource<T>(this.loader, this.processor, this.behavior, this.toString);
        }
    }

    private static final class BasicRequest
    extends Request {
        private final String term;
        private final Supplier<AutoCompletionSource.Behavior> behavior;
        private final Callable<List<?>> callable;

        public BasicRequest(@NonNull String term, @NonNull Supplier<AutoCompletionSource.Behavior> behavior, @NonNull Callable<List<?>> callable) {
            this.term = Objects.requireNonNull(term);
            this.behavior = Objects.requireNonNull(behavior);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        public String getTerm() {
            return this.term;
        }

        @Override
        public AutoCompletionSource.Behavior getBehavior() {
            return this.behavior.get();
        }

        @Override
        public List<?> call() throws Exception {
            return this.callable.call();
        }
    }

    public static interface Loader<T> {
        public @NonNull List<T> load(@NonNull String var1) throws Exception;
    }

    public static interface Builder<T> {
        public @NonNull Builder<T> postProcessor(@NonNull BiFunction<List<T>, String, List<T>> var1);

        public @NonNull Builder<T> behavior(@NonNull Function<? super String, AutoCompletionSource.Behavior> var1);

        default public @NonNull Builder<T> behavior(@NonNull AutoCompletionSource.Behavior behavior) {
            Objects.requireNonNull(behavior);
            return this.behavior((? super String o) -> behavior);
        }

        public @NonNull Builder<T> valueToString(@NonNull Function<T, String> var1);

        public @NonNull Builder<T> cache(@NonNull ConcurrentMap var1, @NonNull Function<? super String, Object> var2, @NonNull Function<? super String, AutoCompletionSource.Behavior> var3);

        default public @NonNull Builder<T> cache(@NonNull ConcurrentMap cache, @NonNull Function<? super String, Object> toKey, @NonNull AutoCompletionSource.Behavior behavior) {
            Objects.requireNonNull(behavior);
            return this.cache(cache, toKey, (? super String o) -> behavior);
        }

        public @NonNull ExtAutoCompletionSource build();
    }

    public static abstract class Request
    implements Callable<List<?>> {
        public abstract @NonNull String getTerm();

        public abstract @NonNull AutoCompletionSource.Behavior getBehavior();
    }
}

