/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion.swing;

import ec.util.completion.AutoCompletionSources;
import ec.util.completion.swing.CustomListModel;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CustomListCellRenderer<T>
extends DefaultListCellRenderer {
    private final boolean highlightTerm;

    public static <T> @NonNull DefaultListCellRenderer of(final @NonNull Function<T, String> toValueAsString, final @NonNull Function<T, String> toToolTipText) {
        return new CustomListCellRenderer<T>(){

            @Override
            protected String getValueAsString(T value) {
                return (String)toValueAsString.apply(value);
            }

            @Override
            protected String toToolTipText(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                return (String)toToolTipText.apply(value);
            }
        };
    }

    public CustomListCellRenderer() {
        this(true);
    }

    public CustomListCellRenderer(boolean highlightTerm) {
        this.highlightTerm = highlightTerm;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String term = list.getModel() instanceof CustomListModel ? ((CustomListModel)list.getModel()).getTerm() : null;
        this.setText(this.toString(term, list, value, index, isSelected, cellHasFocus));
        this.setIcon(this.toIcon(term, list, value, index, isSelected, cellHasFocus));
        this.setToolTipText(this.toToolTipText(term, list, value, index, isSelected, cellHasFocus));
        return result;
    }

    protected @Nullable String toString(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        String valueAsString = this.getValueAsString(value);
        if (!this.highlightTerm || term == null || term.isEmpty()) {
            return valueAsString;
        }
        int beginIndex = this.getNormalizedString(valueAsString).indexOf(this.getNormalizedString(term));
        if (beginIndex == -1) {
            return valueAsString;
        }
        int endIndex = beginIndex + term.length();
        return "<html>" + valueAsString.substring(0, beginIndex) + "<b>" + valueAsString.substring(beginIndex, endIndex) + "</b>" + valueAsString.substring(endIndex);
    }

    protected @Nullable Icon toIcon(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    protected @Nullable String toToolTipText(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    protected @NonNull String getValueAsString(@NonNull T value) {
        return value.toString();
    }

    protected @NonNull String getNormalizedString(@NonNull String input) {
        return AutoCompletionSources.normalize(input);
    }
}

