/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion.swing;

import ec.util.completion.AbstractAutoCompletion;
import ec.util.completion.ExtAutoCompletionSource;
import ec.util.completion.swing.CustomListCellRenderer;
import ec.util.completion.swing.CustomListModel;
import ec.util.completion.swing.XPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;

public class JAutoCompletion
extends AbstractAutoCompletion<JComponent> {
    protected static final String HIDE_ACTION = "HIDE";
    protected static final String INSERT_CURRENT_ACTION = "INSERT_CURRENT";
    protected static final String SELECT_PREV_ACTION = "SELECT_PREV";
    protected static final String SELECT_NEXT_ACTION = "SELECT_NEXT";
    protected final AbstractAutoCompletion.InputView<JTextComponent> inputView;
    protected final AbstractAutoCompletion.SearchView<JList> searchView;
    protected final Timer timer;
    protected long latestId;

    public JAutoCompletion(@NonNull JTextComponent input) {
        this(input, new JList());
    }

    public JAutoCompletion(@NonNull JTextComponent input, @NonNull JList list) {
        this.inputView = new JTextComponentInputView(input);
        this.searchView = new JListSearchView(list);
        this.timer = new Timer(this.delay, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAutoCompletion.this.search();
            }
        });
        this.timer.setRepeats(false);
        this.latestId = 0L;
        this.addPropertyChangeListener(evt -> {
            String p = evt.getPropertyName();
            if (p.equals("delay")) {
                this.timer.setDelay(this.delay);
            }
        });
    }

    void fillMaps(JComponent c) {
        ActionMap am = c.getActionMap();
        am.put(HIDE_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAutoCompletion.this.hide();
            }
        });
        am.put(INSERT_CURRENT_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAutoCompletion.this.insertCurrent();
            }
        });
        am.put(SELECT_PREV_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAutoCompletion.this.selectPrev();
            }
        });
        am.put(SELECT_NEXT_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAutoCompletion.this.selectNext();
            }
        });
        InputMap im = c.getInputMap();
        im.put(KeyStroke.getKeyStroke(27, 0, false), HIDE_ACTION);
        im.put(KeyStroke.getKeyStroke(10, 0, false), INSERT_CURRENT_ACTION);
        im.put(KeyStroke.getKeyStroke(38, 0, false), SELECT_PREV_ACTION);
        im.put(KeyStroke.getKeyStroke(40, 0, false), SELECT_NEXT_ACTION);
    }

    public @NonNull JList getList() {
        return this.searchView.getComponent();
    }

    @Override
    public void close() {
        this.searchView.onClose();
        this.timer.stop();
    }

    @Override
    public void search(String term) {
        if (!this.enabled || term.length() < this.minLength) {
            this.close();
            return;
        }
        this.search(this.getRequest(term));
    }

    private ExtAutoCompletionSource.Request getRequest(String term) {
        return this.source instanceof ExtAutoCompletionSource ? ((ExtAutoCompletionSource)this.source).getRequest(term) : ExtAutoCompletionSource.wrap(this.source, term);
    }

    private void search(final ExtAutoCompletionSource.Request request) {
        switch (request.getBehavior()) {
            case ASYNC: {
                new SwingWorker<List<?>, String>(){
                    final long id;
                    {
                        this.id = ++JAutoCompletion.this.latestId;
                    }

                    @Override
                    protected List<?> doInBackground() throws Exception {
                        this.publish("STARTED");
                        return (List)request.call();
                    }

                    @Override
                    protected void process(List<String> chunks) {
                        JAutoCompletion.this.searchView.onSearchStarted(request.getTerm());
                    }

                    @Override
                    protected void done() {
                        if (!JAutoCompletion.this.inputView.isEditing() || this.id < JAutoCompletion.this.latestId) {
                            return;
                        }
                        try {
                            JAutoCompletion.this.searchView.onSearchDone(request.getTerm(), (List)this.get());
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            JAutoCompletion.this.searchView.onSearchFailed(request.getTerm(), ex);
                        }
                    }
                }.execute();
                break;
            }
            case SYNC: {
                if (!this.inputView.isEditing()) {
                    return;
                }
                try {
                    this.searchView.onSearchDone(request.getTerm(), (List)request.call());
                }
                catch (Exception ex) {
                    this.searchView.onSearchFailed(request.getTerm(), ex);
                }
                break;
            }
        }
    }

    @Override
    protected AbstractAutoCompletion.InputView<JTextComponent> getInputView() {
        return this.inputView;
    }

    @Override
    protected AbstractAutoCompletion.SearchView<JList> getSearchView() {
        return this.searchView;
    }

    private final class JListSearchView
    implements AbstractAutoCompletion.SearchView<JList> {
        private final JList list;
        private final CustomListModel model;
        private final JScrollPane scrollPane;
        private final JLabel message;
        private final XPopup popup;

        JListSearchView(JList view) {
            this.list = view;
            this.model = new CustomListModel();
            this.scrollPane = new JScrollPane(this.list);
            this.message = new JLabel();
            this.popup = new XPopup();
            this.message.setOpaque(true);
            this.message.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Object ex = JListSearchView.this.message.getClientProperty("Exception");
                    if (ex instanceof Exception) {
                        JListSearchView.this.onExceptionDetails((Exception)ex);
                    }
                }
            });
            this.list.setFocusable(false);
            this.list.setSelectionMode(0);
            this.list.setCellRenderer(new CustomListCellRenderer(true));
            this.list.setModel(this.model);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        JAutoCompletion.this.insertCurrent();
                    }
                }
            });
            JAutoCompletion.this.fillMaps(this.list);
        }

        private void onExceptionDetails(Exception ex) {
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            JScrollPane component = new JScrollPane(new JTextArea(errors.toString()));
            component.setPreferredSize(new Dimension(500, 300));
            JOptionPane.showMessageDialog(this.message, component, "Exception details", 0);
        }

        @Override
        public JList getComponent() {
            return this.list;
        }

        @Override
        public void onClose() {
            this.hidePopup();
        }

        @Override
        public void onSearchStarted(String term) {
            this.hidePopup();
            this.message.setText("<html><i>Searching ...");
            this.message.setToolTipText("");
            this.message.putClientProperty("Exception", null);
            this.showPopup(this.message);
        }

        @Override
        public void onSearchFailed(String term, Exception ex) {
            this.hidePopup();
            this.message.setText("<html><i>Error (click for details)");
            this.message.setToolTipText(ex.getMessage());
            this.message.putClientProperty("Exception", ex);
            this.showPopup(this.message);
        }

        @Override
        public void onSearchDone(String term, List<?> values) {
            this.hidePopup();
            this.model.setData(term, values);
            if (values.isEmpty()) {
                return;
            }
            this.scrollPane.setPreferredSize(this.computeSize());
            if (JAutoCompletion.this.autoFocus) {
                this.list.setSelectedIndex(0);
            } else {
                this.list.clearSelection();
            }
            this.list.ensureIndexIsVisible(0);
            this.showPopup(this.scrollPane);
        }

        Dimension computeSize() {
            Dimension size = this.list.getPreferredSize();
            JTextComponent textComponent = JAutoCompletion.this.inputView.getComponent();
            Insets popupInsets = this.scrollPane.getInsets();
            int width = size.width + popupInsets.left + popupInsets.right;
            int minWidth = textComponent.getWidth();
            boolean horizontalScrollBarVisible = false;
            if (width <= minWidth) {
                width = minWidth;
            } else {
                Window window = SwingUtilities.getWindowAncestor(textComponent);
                int x = textComponent.getLocationOnScreen().x - window.getLocationOnScreen().x;
                int maxWidth = window.getWidth() - x - window.getInsets().right;
                if (width > maxWidth) {
                    width = maxWidth;
                    horizontalScrollBarVisible = true;
                }
            }
            int height = size.height + popupInsets.top + popupInsets.bottom + (horizontalScrollBarVisible ? this.getHorizontalScrollBarHeight() : 0);
            int maxHeight = textComponent.getHeight() * 7;
            if (height > maxHeight) {
                height = maxHeight;
            }
            return new Dimension(width, height);
        }

        int getHorizontalScrollBarHeight() {
            int result = this.scrollPane.getHorizontalScrollBar().getHeight();
            return result != 0 ? result : UIManager.getInt("ScrollBar.width");
        }

        void showPopup(Component c) {
            this.popup.show(JAutoCompletion.this.inputView.getComponent(), c, XPopup.Anchor.BOTTOM_LEADING, new Dimension());
        }

        void hidePopup() {
            this.list.clearSelection();
            this.popup.hide();
        }

        @Override
        public void moveSelection(int step, boolean page) {
            int idx = this.list.getSelectedIndex() + step;
            if (0 <= idx && idx < this.model.getSize()) {
                this.list.setSelectedIndex(idx);
                this.list.ensureIndexIsVisible(idx);
            }
        }

        @Override
        public Object getSelectedValue() {
            return this.list.getSelectedValue();
        }
    }

    private final class JTextComponentInputView
    implements AbstractAutoCompletion.InputView<JTextComponent> {
        private final JTextComponent input;
        String previous = "";
        int beginIdx = 0;
        int endIdx = 0;
        boolean listening = true;

        public JTextComponentInputView(JTextComponent input) {
            this.input = input;
            this.input.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    JTextComponentInputView.this.fireDocumentEvent(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    JTextComponentInputView.this.fireDocumentEvent(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.input.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JAutoCompletion.this.close();
                }
            });
            this.input.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    JAutoCompletion.this.close();
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    JAutoCompletion.this.close();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    JAutoCompletion.this.close();
                }
            });
            JAutoCompletion.this.fillMaps(this.input);
        }

        @Override
        public boolean isEditing() {
            return this.input.hasFocus();
        }

        @Override
        public void requestEditing() {
            this.input.requestFocusInWindow();
        }

        @Override
        public JTextComponent getComponent() {
            return this.input;
        }

        void fireDocumentEvent(DocumentEvent e) {
            if (this.listening) {
                SwingUtilities.invokeLater(() -> {
                    String current = this.getTerm();
                    if (!current.equals(this.previous)) {
                        this.previous = current;
                        JAutoCompletion.this.timer.restart();
                    }
                });
            }
        }

        @Override
        public String getTerm() {
            String all = this.input.getText();
            if (JAutoCompletion.this.separator.isEmpty()) {
                this.beginIdx = 0;
                this.endIdx = all.length();
                return all;
            }
            int pos = this.input.getSelectionStart();
            this.beginIdx = pos > 0 ? all.lastIndexOf(JAutoCompletion.this.separator, pos - 1) : -1;
            this.beginIdx = this.beginIdx >= 0 ? this.beginIdx + JAutoCompletion.this.separator.length() : 0;
            this.endIdx = all.indexOf(JAutoCompletion.this.separator, pos);
            this.endIdx = this.endIdx >= 0 ? this.endIdx : all.length();
            return all.substring(this.beginIdx, this.endIdx);
        }

        @Override
        public void setTerm(String value) {
            String oldValue = this.input.getText();
            String newValue = oldValue.substring(0, this.beginIdx) + value + oldValue.substring(this.endIdx);
            this.listening = false;
            this.input.setText(newValue);
            this.input.setSelectionStart(this.beginIdx + value.length());
            this.input.setSelectionEnd(this.beginIdx + value.length());
            this.listening = true;
        }
    }
}

