/*
 * Decompiled with CFR 0.152.
 */
package ec.util.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DataTransfers {
    public static <T> @NonNull Optional<T> getTransferData(@NonNull Transferable t, @NonNull DataFlavor flavor) {
        if (t.isDataFlavorSupported(flavor)) {
            try {
                return Optional.ofNullable(t.getTransferData(flavor));
            }
            catch (UnsupportedFlavorException | ClassCastException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static @NonNull Transferable systemClipboardAsTransferable() {
        return new ClipboardAsTransferable(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    private DataTransfers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class ClipboardAsTransferable
    implements Transferable {
        private static final Logger log = Logger.getLogger(ClipboardAsTransferable.class.getName());
        @lombok.NonNull
        private final Clipboard clipboard;

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            try {
                return this.clipboard.getAvailableDataFlavors();
            }
            catch (IllegalStateException ex) {
                log.log(Level.WARNING, "While getting data flavors from clipboard", ex);
                return new DataFlavor[0];
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            try {
                return this.clipboard.isDataFlavorAvailable(flavor);
            }
            catch (IllegalStateException ex) {
                log.log(Level.WARNING, "While checking data flavor from clipboard", ex);
                return false;
            }
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            try {
                return this.clipboard.getData(flavor);
            }
            catch (IllegalStateException | OutOfMemoryError ex) {
                log.log(Level.WARNING, "While getting data from clipboard", ex);
                return new IOException(ex);
            }
        }

        public ClipboardAsTransferable(@lombok.NonNull Clipboard clipboard) {
            if (clipboard == null) {
                throw new NullPointerException("clipboard is marked non-null but is null");
            }
            this.clipboard = clipboard;
        }
    }
}

