/*
 * Decompiled with CFR 0.152.
 */
package ec.util.datatransfer;

import ec.util.datatransfer.DataTransfers;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LocalDataTransfer<T> {
    private final DataFlavor dataFlavor;
    private final Class<T> dataType;

    public static <T> @NonNull LocalDataTransfer<T> of(@NonNull Class<T> localObjectType) {
        try {
            return new LocalDataTransfer<T>(localObjectType);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private LocalDataTransfer(Class<T> localObjectType) throws ClassNotFoundException {
        this.dataFlavor = new DataFlavor(LocalDataTransfer.localObjectMimeTypeOf(localObjectType));
        this.dataType = localObjectType;
    }

    public @NonNull Transferable createTransferable(@NonNull T localObject) {
        return new LocalObjectTransferable<T>(localObject);
    }

    public @NonNull Optional<T> getData(@NonNull Transferable t) {
        return DataTransfers.getTransferData(t, this.dataFlavor);
    }

    public @NonNull Optional<T> getData( @NonNull TransferHandler.TransferSupport support) {
        return this.getData(support.getTransferable());
    }

    public boolean canImport( @NonNull TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(this.dataFlavor);
    }

    private static String localObjectMimeTypeOf(Class<?> type) {
        return "application/x-java-jvm-local-objectref;class=\"" + type.getName() + "\"";
    }

    public DataFlavor getDataFlavor() {
        return this.dataFlavor;
    }

    public Class<T> getDataType() {
        return this.dataType;
    }

    private final class LocalObjectTransferable<T>
    implements Transferable {
        @lombok.NonNull
        private final T localObject;

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{LocalDataTransfer.this.dataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return LocalDataTransfer.this.dataFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.localObject;
        }

        public LocalObjectTransferable(T localObject) {
            if (localObject == null) {
                throw new NullPointerException("localObject is marked non-null but is null");
            }
            this.localObject = localObject;
        }
    }
}

