/*
 * Decompiled with CFR 0.152.
 */
package ec.util.grid.swing;

import ec.util.grid.CellIndex;
import ec.util.grid.swing.AGrid;
import ec.util.grid.swing.FixedColumnTable;
import ec.util.grid.swing.GridModel;
import ec.util.grid.swing.GridModels;
import ec.util.grid.swing.XTable;
import ec.util.various.swing.LineBorder2;
import ec.util.various.swing.ModernUI;
import ec.util.various.swing.StandardSwingColor;
import internal.Colors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.LayerUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JGrid
extends AGrid {
    private static final int COLUMN_WIDTH = new TableColumn().getPreferredWidth();
    private final XTable main = new XTable();
    private final JScrollPane scrollPane = ModernUI.withEmptyBorders(new JScrollPane(this.main));
    private final FixedColumnTable fct = new FixedColumnTable(1, this.scrollPane);
    private final InternalTableModel internalModel = new InternalTableModel();
    private final CellSelectionListener cellSelectionListener = new CellSelectionListener();
    private final float initialFontSize = this.main.getFont().getSize2D();
    private final int initialRowHeight = this.main.getRowHeight();
    private float zoomRatio = 1.0f;

    public JGrid() {
        this.initComponents();
        this.setInputMap(0, this.main.getInputMap(0));
        this.setInputMap(2, this.main.getInputMap(2));
        this.setInputMap(1, this.main.getInputMap(1));
        this.enableSelectColumnOnHeader();
        JGrid.enableDragOnHeader(this.main.getTableHeader());
        this.enableSelectAllOnHeader();
        JGrid.enableDragOnHeader(this.fct.getFixedTable().getTableHeader());
        this.enableCellHovering();
        this.enableCellSelection();
        this.enableProperties();
        this.setLayout(new BorderLayout());
        this.add(new JLayer<JScrollPane>(this.scrollPane, new DropUI()), "Center");
    }

    private void initComponents() {
        this.main.setModel(this.internalModel);
        this.main.setOddBackground(null);
        this.main.setFillsViewportHeight(true);
        this.main.getTableHeader().setReorderingAllowed(false);
        this.main.setAutoResizeMode(0);
        this.scrollPane.setViewportView(this.main);
        this.scrollPane.getViewport().setBackground(this.main.getBackground());
        this.fct.getFixedTable().getTableHeader().setReorderingAllowed(false);
        this.fct.getFixedTable().setFillsViewportHeight(true);
        this.fct.getFixedTable().setIntercellSpacing(new Dimension(0, 0));
        this.fct.getFixedTable().setShowGrid(false);
        this.internalModel.addTableModelListener(evt -> {
            if (evt.getType() == 0) {
                this.applyZoomRatioOnColumnsWidth();
            }
        });
        this.setRowRenderer(new RowRenderer(this));
        this.setColumnRenderer(new ColumnRenderer(this));
        this.setCornerRenderer(new CornerRenderer());
        this.setDefaultRenderer(Object.class, new GridCellRenderer(this));
        this.onModelChange();
        this.onRowSelectionAllowedChange();
        this.onColumnSelectionAllowedChange();
        this.onDragEnabledChange();
        this.onGridColorChange();
        this.onNoDataRendererChange();
        this.onTransferHandlerChange();
        this.onRowSelectionModelChange();
        this.onColumnSelectionModelChange();
        this.onComponentPopupMenuChange();
    }

    public TableCellRenderer getDefaultRenderer(Class<?> aClass) {
        return this.main.getDefaultRenderer(aClass);
    }

    public void setDefaultRenderer(Class<?> aClass, TableCellRenderer tableCellRenderer) {
        this.main.setDefaultRenderer(aClass, tableCellRenderer);
    }

    public TableCellRenderer getColumnRenderer() {
        return this.main.getTableHeader().getDefaultRenderer();
    }

    public void setColumnRenderer(TableCellRenderer renderer) {
        this.main.getTableHeader().setDefaultRenderer(renderer);
    }

    public TableCellRenderer getRowRenderer() {
        return this.fct.getFixedTable().getDefaultRenderer(Object.class);
    }

    public void setRowRenderer(TableCellRenderer renderer) {
        this.fct.getFixedTable().setDefaultRenderer(Object.class, renderer);
    }

    public void setCornerRenderer(TableCellRenderer renderer) {
        this.fct.getFixedTable().getTableHeader().setDefaultRenderer(renderer);
    }

    @Deprecated
    public void setOddBackground(@Nullable Color oddBackground) {
        this.main.setOddBackground(oddBackground);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.main.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.main.removeMouseListener(l);
        super.removeMouseListener(l);
    }

    @Deprecated
    public void setRowHeight(int rowHeight) {
        this.main.setRowHeight(rowHeight);
    }

    @Deprecated
    public int getRowHeight() {
        return this.main.getRowHeight();
    }

    @Deprecated
    public JTableHeader getTableHeader() {
        return this.main.getTableHeader();
    }

    @Deprecated
    public ListSelectionModel getSelectionModel() {
        return this.getRowSelectionModel();
    }

    @Deprecated
    public TableColumnModel getColumnModel() {
        return this.main.getColumnModel();
    }

    @Deprecated
    public int[] getSelectedColumns() {
        return this.main.getSelectedColumns();
    }

    @Deprecated
    public int[] getSelectedRows() {
        return this.main.getSelectedRows();
    }

    private void onModelChange() {
        this.internalModel.setGridModel(this.model);
    }

    private void onRowSelectionAllowedChange() {
        this.main.setRowSelectionAllowed(this.rowSelectionAllowed);
        this.fct.getFixedTable().setRowSelectionAllowed(this.rowSelectionAllowed);
    }

    private void onColumnSelectionAllowedChange() {
        this.main.setColumnSelectionAllowed(this.columnSelectionAllowed);
    }

    private void onHoveredCellChange() {
        this.scrollPane.repaint();
    }

    private void onSelectedCellChange() {
        if (this.cellSelectionListener.enabled) {
            this.cellSelectionListener.enabled = false;
            CellIndex index = this.getSelectedCell();
            if (CellIndex.NULL.equals((Object)index)) {
                this.getRowSelectionModel().clearSelection();
                this.getColumnSelectionModel().clearSelection();
            } else {
                this.getRowSelectionModel().setSelectionInterval(index.getRow(), index.getRow());
                this.getColumnSelectionModel().setSelectionInterval(index.getColumn(), index.getColumn());
            }
            this.cellSelectionListener.enabled = true;
        }
        this.scrollPane.repaint();
    }

    private void onCrosshairVisibleChange() {
        this.repaint();
    }

    private void onDragEnabledChange() {
        this.main.setDragEnabled(this.dragEnabled);
        this.fct.getFixedTable().setDragEnabled(this.dragEnabled);
    }

    private void onFontChange() {
        Font font = this.getFont();
        this.zoomRatio = font.getSize2D() / this.initialFontSize;
        int rowHeight = (int)((float)this.initialRowHeight * this.zoomRatio);
        this.main.setRowHeight(rowHeight);
        this.fct.getFixedTable().setRowHeight(rowHeight);
        this.applyZoomRatioOnColumnsWidth();
        this.main.setFont(font);
        this.main.getTableHeader().setFont(font);
        this.fct.getFixedTable().setFont(font);
    }

    private void onTransferHandlerChange() {
        TransferHandler handler = this.getTransferHandler();
        this.main.setTransferHandler(handler);
        this.main.getTableHeader().setTransferHandler(handler);
        this.fct.getFixedTable().setTransferHandler(handler);
        this.fct.getFixedTable().getTableHeader().setTransferHandler(handler);
        this.scrollPane.setTransferHandler(handler);
    }

    private void onGridColorChange() {
        this.main.setGridColor(this.gridColor);
    }

    private void onNoDataRendererChange() {
        this.repaint();
    }

    private void onRowSelectionModelChange() {
        this.main.setSelectionModel(this.rowSelectionModel);
    }

    private void onColumnSelectionModelChange() {
        this.main.getColumnModel().setSelectionModel(this.columnSelectionModel);
    }

    private void onComponentPopupMenuChange() {
        JPopupMenu popupMenu = this.getComponentPopupMenu();
        this.main.setComponentPopupMenu(popupMenu);
        this.fct.getFixedTable().setComponentPopupMenu(popupMenu);
        this.scrollPane.setComponentPopupMenu(popupMenu);
    }

    private void enableProperties() {
        this.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "model": {
                    this.onModelChange();
                    break;
                }
                case "rowSelectionAllowed": {
                    this.onRowSelectionAllowedChange();
                    break;
                }
                case "columnSelectionAllowed": {
                    this.onColumnSelectionAllowedChange();
                    break;
                }
                case "hoveredCell": {
                    this.onHoveredCellChange();
                    break;
                }
                case "selectedCell": {
                    this.onSelectedCellChange();
                    break;
                }
                case "crosshairVisible": {
                    this.onCrosshairVisibleChange();
                    break;
                }
                case "dragEnabled": {
                    this.onDragEnabledChange();
                    break;
                }
                case "gridColor": {
                    this.onGridColorChange();
                    break;
                }
                case "noDataRenderer": {
                    this.onNoDataRendererChange();
                    break;
                }
                case "rowSelectionModel": {
                    this.onRowSelectionModelChange();
                    break;
                }
                case "columnSelectionModel": {
                    this.onColumnSelectionModelChange();
                    break;
                }
                case "font": {
                    this.onFontChange();
                    break;
                }
                case "transferHandler": {
                    this.onTransferHandlerChange();
                    break;
                }
                case "componentPopupMenu": {
                    this.onComponentPopupMenuChange();
                }
            }
        });
    }

    private void enableSelectColumnOnHeader() {
        this.main.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selection = JGrid.this.main.getTableHeader().columnAtPoint(e.getPoint());
                JGrid.this.getColumnSelectionModel().setSelectionInterval(selection, selection);
            }
        });
    }

    private void enableSelectAllOnHeader() {
        this.fct.getFixedTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ListSelectionModel columnSelectionModel = JGrid.this.getColumnSelectionModel();
                ListSelectionModel rowSelectionModel = JGrid.this.getRowSelectionModel();
                int columnCount = JGrid.this.main.getColumnCount();
                int rowCount = JGrid.this.main.getRowCount();
                if (columnCount == JGrid.getCount(columnSelectionModel) || rowCount == JGrid.getCount(rowSelectionModel)) {
                    columnSelectionModel.clearSelection();
                    rowSelectionModel.clearSelection();
                } else {
                    columnSelectionModel.setSelectionInterval(0, columnCount - 1);
                    rowSelectionModel.setSelectionInterval(0, rowCount - 1);
                }
            }
        });
    }

    private static void enableDragOnHeader(JTableHeader tableHeader) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(tableHeader, 3, evt -> {
            TransferHandler transferHandler;
            if (tableHeader.getResizingColumn() == null && (transferHandler = tableHeader.getTransferHandler()) != null) {
                transferHandler.exportAsDrag(tableHeader, evt.getTriggerEvent(), 1);
            }
        });
    }

    private CellIndex getIndex(MouseEvent e) {
        if (e.getSource() instanceof JTable) {
            JTable table = (JTable)e.getSource();
            Point point = e.getPoint();
            return CellIndex.valueOf(table.rowAtPoint(point), table.columnAtPoint(point));
        }
        return CellIndex.NULL;
    }

    private void enableCellHovering() {
        MouseMotionAdapter cellFocus = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JGrid.this.setHoveredCell(JGrid.this.getIndex(e));
            }
        };
        this.main.addMouseMotionListener(cellFocus);
        this.main.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JGrid.this.setHoveredCell(JGrid.this.getIndex(e));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JGrid.this.setHoveredCell(JGrid.this.getIndex(e));
            }
        });
    }

    private void enableCellSelection() {
        this.getRowSelectionModel().addListSelectionListener(this.cellSelectionListener);
        this.getColumnSelectionModel().addListSelectionListener(this.cellSelectionListener);
    }

    private static int getCount(ListSelectionModel m) {
        return !m.isSelectionEmpty() ? m.getMaxSelectionIndex() - m.getMinSelectionIndex() + 1 : 0;
    }

    private void applyZoomRatioOnColumnsWidth() {
        int columnWidth = (int)((float)COLUMN_WIDTH * this.zoomRatio);
        JGrid.applyColumnsWidth(columnWidth, this.main);
        JTable j = this.fct.getFixedTable();
        j.setPreferredScrollableViewportSize(new Dimension(columnWidth, this.main.getRowHeight()));
        JGrid.applyColumnsWidth(columnWidth, j);
    }

    private static void applyColumnsWidth(int columnWidth, JTable table) {
        Enumeration<TableColumn> cols = table.getTableHeader().getColumnModel().getColumns();
        while (cols.hasMoreElements()) {
            cols.nextElement().setPreferredWidth(columnWidth);
        }
    }

    private static abstract class CellUIResource {
        private CellUIResource() {
        }

        public abstract @NonNull Color getBackground();

        public abstract @NonNull Color getForeground();

        public abstract @NonNull Border getBorder();

        public static @NonNull CellUIResource of(final Color background, final Color foreground, final Border border) {
            return new CellUIResource(){

                @Override
                public Color getBackground() {
                    return background;
                }

                @Override
                public Color getForeground() {
                    return foreground;
                }

                @Override
                public Border getBorder() {
                    return border;
                }
            };
        }
    }

    private static abstract class GridUIResource {
        private GridUIResource() {
        }

        public abstract @NonNull CellUIResource getHeader(boolean var1, boolean var2);

        public abstract @NonNull CellUIResource getCell(boolean var1, boolean var2);

        public static @NonNull GridUIResource getDefault() {
            return GridColorsImpl.INSTANCE;
        }

        private static final class GridColorsImpl
        extends GridUIResource {
            private static final GridColorsImpl INSTANCE = new GridColorsImpl();
            private final CellUIResource header;
            private final CellUIResource headerSelection;
            private final CellUIResource headerFocus;
            private final CellUIResource headerBoth;
            private final CellUIResource cell;
            private final CellUIResource cellSelection;
            private final CellUIResource cellFocus;
            private final CellUIResource cellBoth;

            private GridColorsImpl() {
                Color headerBackground = StandardSwingColor.TABLE_HEADER_BACKGROUND.lookup().orElseGet(() -> new Color(240, 240, 240));
                Color headerForeground = StandardSwingColor.TABLE_HEADER_FOREGROUND.lookup().orElse(Color.BLACK);
                Color background = StandardSwingColor.TABLE_BACKGROUND.lookup().orElse(Color.WHITE);
                Color foreground = StandardSwingColor.TABLE_FOREGROUND.lookup().orElse(Color.BLACK);
                Color selectionBackground = StandardSwingColor.TABLE_SELECTION_BACKGROUND.lookup().orElseGet(() -> new Color(51, 153, 255));
                Color selectionForeground = StandardSwingColor.TABLE_SELECTION_FOREGROUND.lookup().orElseGet(() -> new Color(255, 255, 255));
                CompoundBorder headerBorder = BorderFactory.createCompoundBorder(new LineBorder2(headerBackground.brighter(), 0, 0, 1, 1), BorderFactory.createEmptyBorder(0, 4, 0, 4));
                Border noBorder = BorderFactory.createEmptyBorder();
                this.header = CellUIResource.of(headerBackground, headerForeground, headerBorder);
                this.headerSelection = CellUIResource.of(selectionBackground.darker(), selectionForeground, headerBorder);
                this.headerFocus = CellUIResource.of(selectionBackground, selectionForeground, headerBorder);
                this.headerBoth = CellUIResource.of(selectionBackground, selectionForeground, headerBorder);
                this.cell = CellUIResource.of(background, foreground, noBorder);
                this.cellSelection = CellUIResource.of(selectionBackground, selectionForeground, noBorder);
                this.cellFocus = CellUIResource.of(Colors.withAlpha(selectionBackground, 200), selectionForeground, noBorder);
                this.cellBoth = CellUIResource.of(Colors.withAlpha(selectionBackground, 200), selectionForeground, noBorder);
            }

            @Override
            public CellUIResource getHeader(boolean selected, boolean hovered) {
                return selected ? (hovered ? this.headerBoth : this.headerSelection) : (hovered ? this.headerFocus : this.header);
            }

            @Override
            public CellUIResource getCell(boolean selected, boolean hovered) {
                return selected ? (hovered ? this.cellBoth : this.cellSelection) : (hovered ? this.cellFocus : this.cell);
            }
        }
    }

    private static final class GridCellRenderer
    implements TableCellRenderer {
        private final JGrid grid;
        protected final JLabel renderer;
        private final GridUIResource gridResource;

        public GridCellRenderer(@NonNull JGrid grid) {
            this.grid = grid;
            this.renderer = new DefaultTableCellRenderer();
            this.gridResource = GridUIResource.getDefault();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer.setFont(table.getFont());
            CellIndex hoveredCell = this.grid.getHoveredCell();
            boolean focused = !this.grid.isCrosshairVisible() ? hoveredCell.equals(row, column) : hoveredCell.getRow() == row || hoveredCell.getColumn() == column;
            CellUIResource resource = this.gridResource.getCell(isSelected, focused);
            this.renderer.setBorder(resource.getBorder());
            this.renderer.setBackground(resource.getBackground());
            this.renderer.setForeground(resource.getForeground());
            this.renderer.setText(value != null ? value.toString() : null);
            return this.renderer;
        }
    }

    private static final class CornerRenderer
    extends HeaderRenderer {
        private CornerRenderer() {
        }

        @Override
        protected boolean isHeaderSelected(JTable table, int row, int column) {
            return false;
        }

        @Override
        protected boolean isHeaderHovered(JTable table, int row, int column) {
            return false;
        }
    }

    private static final class ColumnRenderer
    extends HeaderRenderer {
        private final JGrid grid;

        public ColumnRenderer(JGrid grid) {
            this.grid = grid;
            this.renderer.setHorizontalAlignment(0);
        }

        @Override
        protected boolean isHeaderSelected(JTable table, int row, int column) {
            return table.getColumnSelectionAllowed() && table.isColumnSelected(column);
        }

        @Override
        protected boolean isHeaderHovered(JTable table, int row, int column) {
            return this.grid.getHoveredCell().getColumn() == column;
        }
    }

    private static final class RowRenderer
    extends HeaderRenderer {
        private final JGrid grid;

        public RowRenderer(JGrid grid) {
            this.grid = grid;
            this.renderer.setHorizontalAlignment(0);
        }

        @Override
        protected boolean isHeaderSelected(JTable table, int row, int column) {
            return table.getRowSelectionAllowed() && table.isRowSelected(row);
        }

        @Override
        protected boolean isHeaderHovered(JTable table, int row, int column) {
            return this.grid.getHoveredCell().getRow() == row;
        }
    }

    private static abstract class HeaderRenderer
    implements TableCellRenderer {
        protected final JLabel renderer = new DefaultTableCellRenderer();
        protected final GridUIResource gridResource = GridUIResource.getDefault();

        public HeaderRenderer() {
            this.renderer.setOpaque(true);
        }

        protected abstract boolean isHeaderSelected(JTable var1, int var2, int var3);

        protected abstract boolean isHeaderHovered(JTable var1, int var2, int var3);

        @Override
        public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            String string = text = value != null ? value.toString() : "";
            if (text.isEmpty()) {
                this.renderer.setText(" ");
                this.renderer.setToolTipText(null);
            } else if (text.startsWith("<html>")) {
                this.renderer.setText(text);
                this.renderer.setToolTipText(text);
            } else {
                this.renderer.setText(text);
                this.renderer.setToolTipText(text);
            }
            this.renderer.setFont(table.getFont());
            CellUIResource cellResource = this.gridResource.getHeader(this.isHeaderSelected(table, row, column), this.isHeaderHovered(table, row, column));
            this.renderer.setBackground(cellResource.getBackground());
            this.renderer.setForeground(cellResource.getForeground());
            this.renderer.setBorder(cellResource.getBorder());
            int preferredHeight = table.getRowHeight() + 1;
            if (this.renderer.getPreferredSize().height != preferredHeight) {
                this.renderer.setPreferredSize(new Dimension(10, preferredHeight));
            }
            return this.renderer;
        }
    }

    private static abstract class ForwardingListener
    implements DropTargetListener {
        private ForwardingListener() {
        }

        protected abstract @Nullable DropTarget getDelegate();

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            DropTarget dt = this.getDelegate();
            if (dt != null) {
                dt.dragEnter(dtde);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            DropTarget dt = this.getDelegate();
            if (dt != null) {
                dt.dragOver(dtde);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            DropTarget dt = this.getDelegate();
            if (dt != null) {
                dt.dropActionChanged(dtde);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DropTarget dt = this.getDelegate();
            if (dt != null) {
                dt.dragExit(dte);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropTarget dt = this.getDelegate();
            if (dt != null) {
                dt.drop(dtde);
            }
        }
    }

    private final class DropUI
    extends LayerUI<JScrollPane> {
        private static final String DROP_PROPERTY = "drop";
        private final CellRendererPane cellRendererPane = new CellRendererPane();
        private boolean drop = false;
        private DropTarget dropTarget = null;

        private DropUI() {
        }

        private void setDrop(boolean hasDropLocation) {
            boolean old = this.drop;
            this.drop = hasDropLocation;
            this.firePropertyChange(DROP_PROPERTY, old, this.drop);
        }

        @Override
        public void applyPropertyChange(PropertyChangeEvent evt, JLayer<? extends JScrollPane> l) {
            if (evt.getPropertyName().equals(DROP_PROPERTY)) {
                l.repaint();
            }
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            this.dropTarget = new DropTarget(JGrid.this.scrollPane, new ForwardingListener(){

                @Override
                protected DropTarget getDelegate() {
                    return JGrid.this.main.getDropTarget();
                }

                @Override
                public void dragEnter(DropTargetDragEvent dtde) {
                    final AtomicBoolean drop = new AtomicBoolean(false);
                    DropTargetDragEvent dropEvent = new DropTargetDragEvent(dtde.getDropTargetContext(), dtde.getLocation(), dtde.getDropAction(), dtde.getSourceActions()){

                        @Override
                        public void acceptDrag(int dragOperation) {
                            super.acceptDrag(dragOperation);
                            drop.set(true);
                        }
                    };
                    super.dragEnter(dropEvent);
                    DropUI.this.setDrop(drop.get());
                }

                @Override
                public void dragExit(DropTargetEvent dte) {
                    super.dragExit(dte);
                    DropUI.this.setDrop(false);
                }

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    super.drop(dtde);
                    DropUI.this.setDrop(false);
                }
            });
            JGrid.this.main.addPropertyChangeListener(this::onPropertyChangeInTable);
            JGrid.this.fct.getFixedTable().addPropertyChangeListener(this::onPropertyChangeInTable);
        }

        private void onPropertyChangeInTable(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "dropLocation": {
                    JTable table = (JTable)evt.getSource();
                    this.setDrop(table.getDropLocation() != null);
                }
            }
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            if (!JGrid.this.internalModel.hasData() || this.drop) {
                this.cellRendererPane.paintComponent(g, JGrid.this.noDataRenderer.getNoDataRendererComponent(JGrid.this.main, this.drop), c, 0, 0, c.getWidth(), c.getHeight());
            }
        }
    }

    private static final class InternalTableModel
    extends AbstractTableModel
    implements TableModelListener {
        private GridModel gridModel = GridModels.empty();

        InternalTableModel() {
        }

        public void setGridModel(GridModel gridModel) {
            this.gridModel.removeTableModelListener(this);
            this.gridModel = gridModel != null ? gridModel : GridModels.empty();
            this.gridModel.addTableModelListener(this);
            this.fireTableStructureChanged();
        }

        public GridModel getGridModel() {
            return this.gridModel;
        }

        public boolean hasData() {
            return this.gridModel.getRowCount() > 0 || this.gridModel.getColumnCount() > 0;
        }

        @Override
        public int getRowCount() {
            return this.gridModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.gridModel.getColumnCount() + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.gridModel.getRowName(rowIndex) : this.gridModel.getValueAt(rowIndex, columnIndex - 1);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? null : this.gridModel.getColumnName(columnIndex - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : this.gridModel.getColumnClass(columnIndex - 1);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    private final class CellSelectionListener
    implements ListSelectionListener {
        boolean enabled = true;

        private CellSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.enabled && !e.getValueIsAdjusting()) {
                this.enabled = false;
                ListSelectionModel rowSelectionModel = JGrid.this.getRowSelectionModel();
                ListSelectionModel columnSelectionModel = JGrid.this.getColumnSelectionModel();
                if (rowSelectionModel.isSelectionEmpty() || columnSelectionModel.isSelectionEmpty()) {
                    JGrid.this.setSelectedCell(CellIndex.NULL);
                } else {
                    int row = rowSelectionModel.getLeadSelectionIndex();
                    int column = columnSelectionModel.getLeadSelectionIndex();
                    if (!JGrid.this.getSelectedCell().equals(row, column)) {
                        JGrid.this.setSelectedCell(CellIndex.valueOf(row, column));
                    }
                }
                this.enabled = true;
            }
        }
    }
}

