/*
 * Decompiled with CFR 0.152.
 */
package ec.util.grid.swing;

import ec.util.table.swing.JTables;
import ec.util.various.swing.ModernUI;
import ec.util.various.swing.StandardSwingColor;
import internal.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class XTable
extends JTable {
    public static final String CELL_PADDING_PROPERTY = "Table.cellPadding";
    public static final String ODD_BACKGROUND_PROPERTY = "Table.oddBackground";
    public static final String NO_DATA_RENDERER_PROPERTY = "noDataRenderer";
    protected static final Dimension DEFAULT_CELL_PADDING = new Dimension(4, 2);
    protected static final Color DEFAULT_ODD_BACKGROUND = new Color(250, 250, 250);
    protected static final NoDataRenderer DEFAULT_NO_DATA_RENDERER = new DefaultNoDataRenderer();
    protected Dimension cellPadding;
    protected Color oddBackground;
    protected NoDataRenderer noDataRenderer;
    private final CellRendererPane cellRendererPane = new CellRendererPane();
    private final PaddingBorder cellBorder;
    private boolean hasDropLocation = false;
    private JComponent toolTipFactory = null;

    public XTable() {
        this.cellPadding = Optional.ofNullable(UIManager.getDimension(CELL_PADDING_PROPERTY)).orElse(DEFAULT_CELL_PADDING);
        this.oddBackground = Optional.ofNullable(UIManager.getColor(ODD_BACKGROUND_PROPERTY)).orElse(DEFAULT_ODD_BACKGROUND);
        this.noDataRenderer = DEFAULT_NO_DATA_RENDERER;
        this.cellBorder = new PaddingBorder();
        this.initTable();
        this.enableProperties();
    }

    private void initTable() {
        StandardSwingColor.CONTROL.lookup().ifPresent(this::setGridColor);
        this.onCellPaddingChange();
    }

    private void enableProperties() {
        this.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "dropLocation": {
                    this.hasDropLocation = evt.getNewValue() != null;
                    this.onNoDataRendererChange();
                    break;
                }
                case "Table.cellPadding": {
                    this.onCellPaddingChange();
                    break;
                }
                case "Table.oddBackground": {
                    this.onOddBackgroundChange();
                    break;
                }
                case "noDataRenderer": {
                    this.onNoDataRendererChange();
                }
            }
        });
    }

    protected void onCellPaddingChange() {
        this.cellBorder.setPadding(this.cellPadding);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + this.cellPadding.height * 2 + 1);
    }

    protected void onOddBackgroundChange() {
        this.repaint();
    }

    protected void onNoDataRendererChange() {
        if (this.getRowCount() == 0) {
            this.repaint();
        }
    }

    public void setCellPadding(@Nullable Dimension cellPadding) {
        Dimension old = this.cellPadding;
        this.cellPadding = cellPadding != null ? cellPadding : DEFAULT_CELL_PADDING;
        this.firePropertyChange(CELL_PADDING_PROPERTY, old, this.cellPadding);
    }

    public void setOddBackground(@Nullable Color oddBackground) {
        Color old = this.oddBackground;
        this.oddBackground = oddBackground;
        this.firePropertyChange(ODD_BACKGROUND_PROPERTY, old, this.oddBackground);
    }

    public @NonNull NoDataRenderer getNoDataRenderer() {
        return this.noDataRenderer;
    }

    public void setNoDataRenderer(@Nullable NoDataRenderer noDataRenderer) {
        NoDataRenderer old = this.noDataRenderer;
        this.noDataRenderer = noDataRenderer != null ? noDataRenderer : DEFAULT_NO_DATA_RENDERER;
        this.firePropertyChange(NO_DATA_RENDERER_PROPERTY, old, this.noDataRenderer);
    }

    @Override
    public JToolTip createToolTip() {
        return this.toolTipFactory != null ? this.toolTipFactory.createToolTip() : super.createToolTip();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TableCellRenderer renderer;
        Component component;
        String tip = null;
        Point p = event.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        if (hitColumnIndex != -1 && hitRowIndex != -1 && (component = this.prepareRenderer(renderer = this.getCellRenderer(hitRowIndex, hitColumnIndex), hitRowIndex, hitColumnIndex)) instanceof JComponent) {
            Rectangle cellRect = this.getCellRect(hitRowIndex, hitColumnIndex, false);
            p.translate(-cellRect.x, -cellRect.y);
            MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), 0);
            tip = ((JComponent)component).getToolTipText(newEvent);
            this.toolTipFactory = (JComponent)component;
        }
        if (tip == null) {
            tip = this.getToolTipText();
            this.toolTipFactory = null;
        }
        return tip;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component result = super.prepareRenderer(renderer, row, column);
        if (this.oddBackground != null && !this.isPaintingForPrint() && !this.isCellSelected(row, column)) {
            result.setBackground(row % 2 == 0 ? this.getBackground() : this.oddBackground);
        }
        this.cellBorder.apply(result);
        return result;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return super.getScrollableTracksViewportHeight();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getRowCount() == 0) {
            this.paintNoData(g);
        }
    }

    protected void paintNoData(Graphics g) {
        this.cellRendererPane.paintComponent(g, this.noDataRenderer.getNoDataRendererComponent(this, this.hasDropLocation), this, 0, 0, this.getWidth(), this.getHeight());
    }

    @Deprecated
    public static void setWidthAsPercentages(JTable table, double ... percentages) {
        JTables.setWidthAsPercentages(table, percentages);
    }

    private static final class PaddingBorder
    extends CompoundBorder {
        private PaddingBorder() {
        }

        public void setPadding(Dimension cellPadding) {
            this.insideBorder = BorderFactory.createEmptyBorder(cellPadding.height, cellPadding.width, cellPadding.height, cellPadding.width);
        }

        public void apply(Component c) {
            if (c instanceof JComponent) {
                this.apply((JComponent)c);
            }
        }

        public void apply(JComponent c) {
            if (c.getBorder() != this) {
                this.outsideBorder = c.getBorder();
                c.setBorder(this);
            }
        }
    }

    public static class DefaultNoDataRenderer
    implements NoDataRenderer {
        private final JLabel label = new JLabel();
        private final String message;
        private final String onDropMessage;

        public DefaultNoDataRenderer() {
            this("No data", "Drop data");
        }

        public DefaultNoDataRenderer(@NonNull String message) {
            this(message, message);
        }

        public DefaultNoDataRenderer(@NonNull String message, @NonNull String onDropMessage) {
            this.message = message;
            this.onDropMessage = onDropMessage;
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(0);
        }

        @Override
        public Component getNoDataRendererComponent(JTable table, boolean hasDropLocation) {
            if (hasDropLocation) {
                this.label.setText(this.onDropMessage);
                this.label.setForeground(table.getSelectionForeground());
                this.label.setBackground(Colors.withAlpha(table.getSelectionBackground(), 200));
                this.label.setBorder(ModernUI.createDropBorder(this.label.getForeground()));
            } else {
                this.label.setText(this.message);
                this.label.setForeground(Colors.withAlpha(table.getForeground(), 100));
                this.label.setBackground(table.getBackground());
                this.label.setBorder(null);
            }
            if (this.label.getText().startsWith("<html>")) {
                this.label.setFont(table.getFont());
            } else {
                this.label.setFont(table.getFont().deriveFont(table.getFont().getSize2D() * 2.0f));
            }
            return this.label;
        }
    }

    @FunctionalInterface
    public static interface NoDataRenderer {
        public Component getNoDataRendererComponent(JTable var1, boolean var2);
    }
}

