/*
 * Decompiled with CFR 0.152.
 */
package ec.util.list.swing;

import ec.util.datatransfer.LocalDataTransfer;
import ec.util.list.swing.JLists;
import ec.util.various.swing.JCommand;
import ec.util.various.swing.ModernUI;
import internal.ToolBarIcon;
import java.awt.BorderLayout;
import java.awt.datatransfer.Transferable;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JListOrdering<T>
extends JComponent {
    public static final String MODEL_PROPERTY = "model";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String MOVE_UP_ACTION = "moveUp";
    public static final String MOVE_DOWN_ACTION = "moveDown";
    private final JList<T> list = new JList();
    private DefaultListModel<T> model = new DefaultListModel();
    private ListCellRenderer<? super T> cellRenderer = new DefaultListCellRenderer();
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();

    public JListOrdering() {
        this.initComponents();
        this.enableProperties();
    }

    private void initComponents() {
        ActionMap am = this.getActionMap();
        am.put(MOVE_UP_ACTION, MoveUp.INSTANCE.toAction(this));
        am.put(MOVE_DOWN_ACTION, MoveDown.INSTANCE.toAction(this));
        this.list.setTransferHandler(new ListItemTransferHandler());
        this.list.setDropMode(DropMode.INSERT);
        this.list.setDragEnabled(true);
        this.setBackground(this.list.getBackground());
        this.setForeground(this.list.getForeground());
        this.setFont(this.list.getFont());
        this.onModelChange();
        this.onCellRendererChange();
        this.onSelectionModelChange();
        this.onEnabledChange();
        this.setLayout(new BorderLayout());
        this.add(ModernUI.withEmptyBorders(new JScrollPane(this.list)));
    }

    private void enableProperties() {
        this.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "model": {
                    this.onModelChange();
                    break;
                }
                case "cellRenderer": {
                    this.onCellRendererChange();
                    break;
                }
                case "selectionModel": {
                    this.onSelectionModelChange();
                    break;
                }
                case "enabled": {
                    this.onEnabledChange();
                    break;
                }
                case "componentPopupMenu": {
                    this.onComponentPopupMenuChange();
                }
            }
        });
    }

    private void onModelChange() {
        this.list.setModel(this.model);
    }

    private void onCellRendererChange() {
        this.list.setCellRenderer(this.cellRenderer);
    }

    private void onSelectionModelChange() {
        this.list.setSelectionModel(this.selectionModel);
    }

    private void onEnabledChange() {
        this.list.setEnabled(this.isEnabled());
    }

    private void onComponentPopupMenuChange() {
        this.list.setComponentPopupMenu(this.getComponentPopupMenu());
    }

    public @NonNull DefaultListModel<T> getModel() {
        return this.model;
    }

    public void setModel(@Nullable DefaultListModel<T> model) {
        DefaultListModel<T> old = this.model;
        this.model = model != null ? model : new DefaultListModel();
        this.firePropertyChange(MODEL_PROPERTY, old, this.model);
    }

    public @NonNull ListCellRenderer<? super T> getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(@Nullable ListCellRenderer<? super T> cellRenderer) {
        ListCellRenderer<? super T> old = this.cellRenderer;
        this.cellRenderer = cellRenderer != null ? cellRenderer : new DefaultListCellRenderer();
        this.firePropertyChange(CELL_RENDERER_PROPERTY, old, this.cellRenderer);
    }

    public @NonNull ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(@Nullable ListSelectionModel selectionModel) {
        ListSelectionModel old = this.selectionModel;
        this.selectionModel = selectionModel != null ? selectionModel : new DefaultListSelectionModel();
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, old, this.selectionModel);
    }

    public void ensureIndexIsVisible(int index) {
        this.list.ensureIndexIsVisible(index);
    }

    public JToolBar createToolBar() {
        ActionMap am = this.getActionMap();
        JToolBar result = new JToolBar();
        result.add(am.get(MOVE_UP_ACTION)).setIcon(ToolBarIcon.MOVE_UP.value());
        result.add(am.get(MOVE_DOWN_ACTION)).setIcon(ToolBarIcon.MOVE_DOWN.value());
        return result;
    }

    private static final class MoveDown
    extends JCommand<JListOrdering<?>> {
        private static final MoveDown INSTANCE = new MoveDown();

        private MoveDown() {
        }

        @Override
        public void execute(JListOrdering<?> c) {
            ListSelectionModel selectionModel = c.getSelectionModel();
            int index = selectionModel.getMinSelectionIndex();
            JLists.move(((JListOrdering)c).model, ((JListOrdering)c).model, new int[]{index}, index + 1);
            selectionModel.setSelectionInterval(index + 1, index + 1);
            c.ensureIndexIsVisible(index + 1);
        }

        @Override
        public boolean isEnabled(JListOrdering<?> c) {
            int max;
            if (!c.isEnabled()) {
                return false;
            }
            ListSelectionModel selectionModel = c.getSelectionModel();
            if (selectionModel.isSelectionEmpty()) {
                return false;
            }
            int min = selectionModel.getMinSelectionIndex();
            return min == (max = selectionModel.getMaxSelectionIndex()) && max < c.getModel().getSize() - 1;
        }

        @Override
        public JCommand.ActionAdapter toAction(JListOrdering<?> c) {
            return super.toAction(c).withWeakListSelectionListener(c.getSelectionModel()).withWeakPropertyChangeListener(c, new String[0]);
        }
    }

    private static final class MoveUp
    extends JCommand<JListOrdering<?>> {
        private static final MoveUp INSTANCE = new MoveUp();

        private MoveUp() {
        }

        @Override
        public void execute(JListOrdering<?> c) {
            ListSelectionModel selectionModel = c.getSelectionModel();
            int index = selectionModel.getMinSelectionIndex();
            JLists.move(((JListOrdering)c).model, ((JListOrdering)c).model, new int[]{index}, index - 1);
            selectionModel.setSelectionInterval(index - 1, index - 1);
            c.ensureIndexIsVisible(index - 1);
        }

        @Override
        public boolean isEnabled(JListOrdering<?> c) {
            int max;
            if (!c.isEnabled()) {
                return false;
            }
            ListSelectionModel selectionModel = c.getSelectionModel();
            if (selectionModel.isSelectionEmpty()) {
                return false;
            }
            int min = selectionModel.getMinSelectionIndex();
            return min == (max = selectionModel.getMaxSelectionIndex()) && min > 0;
        }

        @Override
        public JCommand.ActionAdapter toAction(JListOrdering<?> c) {
            return super.toAction(c).withWeakListSelectionListener(c.getSelectionModel()).withWeakPropertyChangeListener(c, new String[0]);
        }
    }

    private static final class ListItemTransferHandler
    extends TransferHandler {
        private static final LocalDataTransfer<int[]> INT_ARRAY = LocalDataTransfer.of(int[].class);

        private ListItemTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return INT_ARRAY.createTransferable(((JList)c).getSelectedIndices());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDrop() && INT_ARRAY.canImport(info);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            INT_ARRAY.getData(support).ifPresent(o -> this.importData((int[])o, (JList)support.getComponent(), (JList.DropLocation)support.getDropLocation()));
            return true;
        }

        private void importData(int[] indices, JList target, JList.DropLocation dl) {
            int index = dl.getIndex();
            if (indices[0] < index) {
                index -= indices.length;
            }
            JLists.move((DefaultListModel)target.getModel(), (DefaultListModel)target.getModel(), indices, index);
            target.getSelectionModel().setSelectionInterval(index, index + indices.length - 1);
        }
    }
}

