/*
 * Decompiled with CFR 0.152.
 */
package ec.util.table.swing;

import java.awt.Component;
import java.util.function.BiConsumer;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class JTables {
    public static <E> @NonNull TableCellRenderer cellRendererOf(@NonNull BiConsumer<JLabel, E> consumer) {
        return new LabelTableCellRenderer<E>(consumer);
    }

    public static void setWidthAsPercentages(@NonNull JTable table, double ... percentages) {
        double factor = 10000.0;
        TableColumnModel model = table.getColumnModel();
        for (int columnIndex = 0; columnIndex < percentages.length; ++columnIndex) {
            TableColumn column = model.getColumn(columnIndex);
            column.setPreferredWidth((int)(percentages[columnIndex] * 10000.0));
        }
    }

    private JTables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class LabelTableCellRenderer<T>
    implements TableCellRenderer {
        @lombok.NonNull
        private final BiConsumer<JLabel, T> consumer;
        private final DefaultTableCellRenderer delegate = new DefaultTableCellRenderer();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.consumer.accept(this.delegate, (JLabel)value);
            return this.delegate;
        }

        public LabelTableCellRenderer(@lombok.NonNull BiConsumer<JLabel, T> consumer) {
            if (consumer == null) {
                throw new NullPointerException("consumer is marked non-null but is null");
            }
            this.consumer = consumer;
        }
    }
}

