/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BasicSwingLauncher {
    private static final Logger LOGGER = Logger.getLogger(BasicSwingLauncher.class.getName());
    private String lookAndFeelClassName = null;
    private String title = null;
    private Dimension size = null;
    private Callable<? extends Component> contentSupplier = null;
    private boolean centerOnScreen = true;
    private Callable<? extends List<? extends Image>> iconsSupplier = null;
    private boolean resizable = true;

    public @NonNull BasicSwingLauncher logLevel(@Nullable Level level) {
        LOGGER.setLevel(level);
        return this;
    }

    public @NonNull BasicSwingLauncher systemLookAndFeel() {
        return this.lookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public @NonNull BasicSwingLauncher lookAndFeel(@Nullable String lookAndFeelClassName) {
        this.lookAndFeelClassName = lookAndFeelClassName;
        return this;
    }

    public @NonNull BasicSwingLauncher title(@Nullable String title) {
        this.title = title;
        return this;
    }

    public @NonNull BasicSwingLauncher size(int width, int height) {
        return this.size(new Dimension(width, height));
    }

    public @NonNull BasicSwingLauncher size(@Nullable Dimension size) {
        this.size = size;
        return this;
    }

    public @NonNull BasicSwingLauncher content(@Nullable Class<? extends Component> contentClass) {
        return this.content(contentClass == null ? null : contentClass::newInstance);
    }

    public @NonNull BasicSwingLauncher content(@Nullable Callable<? extends Component> contentSupplier) {
        this.contentSupplier = contentSupplier;
        return this;
    }

    public @NonNull BasicSwingLauncher centerOnScreen(boolean centerOnScreen) {
        this.centerOnScreen = centerOnScreen;
        return this;
    }

    public @NonNull BasicSwingLauncher resizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public @NonNull BasicSwingLauncher icons(String ... iconsPaths) {
        return this.icons(BasicSwingLauncher.newImageList(iconsPaths));
    }

    public @NonNull BasicSwingLauncher icons(@Nullable Callable<? extends List<? extends Image>> iconsSupplier) {
        this.iconsSupplier = iconsSupplier;
        return this;
    }

    public void launch() {
        BasicSwingLauncher.launch(this.lookAndFeelClassName != null ? this.lookAndFeelClassName : UIManager.getSystemLookAndFeelClassName(), this.title != null ? this.title : "SimpleApp", this.size != null ? this.size : new Dimension(800, 600), this.contentSupplier != null ? this.contentSupplier : JPanel::new, this.iconsSupplier != null ? this.iconsSupplier : BasicSwingLauncher.newImageList(new String[0]), this.centerOnScreen, this.resizable);
    }

    private static void launch(@NonNull String lookAndFeelClassName, @NonNull String title, @NonNull Dimension size, @NonNull Callable<? extends Component> contentSupplier, @NonNull Callable<? extends List<? extends Image>> iconsSupplier, boolean centerOnScreen, boolean resizable) {
        LOGGER.log(Level.FINE, "lookAndFeelClassName='%s'", lookAndFeelClassName);
        LOGGER.log(Level.FINE, "title='{0}'", title);
        LOGGER.log(Level.FINE, "size='{0}'", size);
        LOGGER.log(Level.FINE, "contentSupplier='{0}'", contentSupplier);
        LOGGER.log(Level.FINE, "centerOnScreen='{0}'", centerOnScreen);
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            LOGGER.log(Level.WARNING, "Cannot set look&feel", ex);
        }
        SwingUtilities.invokeLater(() -> {
            try {
                JFrame frame = new JFrame();
                frame.setTitle(title);
                frame.setIconImages((List)iconsSupplier.call());
                frame.getContentPane().add((Component)contentSupplier.call());
                frame.setDefaultCloseOperation(3);
                frame.setSize(size);
                frame.setResizable(resizable);
                if (centerOnScreen) {
                    frame.setLocationRelativeTo(null);
                }
                frame.setVisible(true);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Cannot launch app", ex);
            }
        });
    }

    private static @NonNull Callable<List<? extends Image>> newImageList(String ... iconsPaths) {
        return () -> Arrays.stream(iconsPaths).map(o -> BasicSwingLauncher.class.getResource((String)o)).filter(o -> o != null).map(o -> new ImageIcon((URL)o).getImage()).collect(Collectors.toList());
    }
}

