/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class JCommand<C> {
    private static final Logger LOGGER = Logger.getLogger(JCommand.class.getName());

    public static <X> @NonNull JCommand<X> of(final @NonNull Consumer<X> consumer) {
        return new JCommand<X>(){

            @Override
            public void execute(X component) throws Exception {
                consumer.accept(component);
            }
        };
    }

    public abstract void execute(@NonNull C var1) throws Exception;

    public @Nullable Exception executeSafely(@NonNull C component) {
        try {
            this.execute(component);
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "While executing command", ex);
            return ex;
        }
    }

    public boolean isEnabled(@NonNull C component) {
        return true;
    }

    public boolean isSelected(@NonNull C component) {
        return false;
    }

    public @NonNull ActionAdapter toAction(@NonNull C component) {
        return new ActionAdapter(component);
    }

    private static abstract class WeakListSelectionListener
    extends WeakEventListener<ListSelectionListener>
    implements ListSelectionListener {
        public WeakListSelectionListener(@NonNull ListSelectionListener delegate) {
            super(delegate);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionListener listener = (ListSelectionListener)this.delegate.get();
            if (listener != null) {
                listener.valueChanged(e);
            } else {
                this.unregister(e.getSource());
            }
        }
    }

    private static abstract class WeakPropertyChangeListener
    extends WeakEventListener<PropertyChangeListener>
    implements PropertyChangeListener {
        public WeakPropertyChangeListener(@NonNull PropertyChangeListener delegate) {
            super(delegate);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener listener = (PropertyChangeListener)this.delegate.get();
            if (listener != null) {
                listener.propertyChange(evt);
            } else {
                this.unregister(evt.getSource());
            }
        }
    }

    public static abstract class WeakEventListener<T extends EventListener>
    implements EventListener {
        protected final WeakReference<T> delegate;

        public WeakEventListener(@NonNull T delegate) {
            this.delegate = new WeakReference<T>(delegate);
        }

        protected abstract void unregister(@NonNull Object var1);
    }

    public class ActionAdapter
    extends AbstractAction {
        private final @NonNull C component;
        private boolean listening;

        public ActionAdapter(C component) {
            this.component = component;
            this.listening = true;
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Exception ex;
            this.listening = false;
            if (this.isEnabled() && (ex = JCommand.this.executeSafely(this.component)) != null) {
                this.handleException(e, ex);
            }
            this.listening = true;
            this.refreshActionState();
        }

        public void handleException(ActionEvent event, Exception ex) {
        }

        public final void refreshActionState() {
            if (this.listening) {
                this.setEnabled(JCommand.this.isEnabled(this.component));
                this.putValue("SwingSelectedKey", JCommand.this.isSelected(this.component));
            }
        }

        public @NonNull ActionAdapter withWeakPropertyChangeListener(@NonNull Component source, String ... properties) {
            PropertyChangeListener realListener = evt -> this.refreshActionState();
            this.putValue("PropertyChangeListener", realListener);
            if (properties.length > 0) {
                for (final String property : properties) {
                    source.addPropertyChangeListener(property, new WeakPropertyChangeListener(realListener){

                        @Override
                        protected void unregister(Object source) {
                            ((Component)source).removePropertyChangeListener(property, this);
                        }
                    });
                }
            } else {
                source.addPropertyChangeListener(new WeakPropertyChangeListener(realListener){

                    @Override
                    protected void unregister(Object source) {
                        ((Component)source).removePropertyChangeListener(this);
                    }
                });
            }
            return this;
        }

        public @NonNull ActionAdapter withWeakListSelectionListener(@NonNull ListSelectionModel source) {
            ListSelectionListener realListener = evt -> this.refreshActionState();
            this.putValue("ListSelectionListener", realListener);
            source.addListSelectionListener(new WeakListSelectionListener(realListener){

                @Override
                protected void unregister(Object source) {
                    ((ListSelectionModel)source).removeListSelectionListener(this);
                }
            });
            return this;
        }

        @Deprecated
        public void registerPropertyChangeListener(@NonNull Container source) {
            this.withWeakPropertyChangeListener(source, new String[0]);
        }

        @Deprecated
        public void registerListSelectionListener(@NonNull ListSelectionModel source) {
            this.withWeakListSelectionListener(source);
        }
    }
}

