/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ModernUI {
    private ModernUI() {
    }

    public static <X extends JScrollPane> @NonNull X withEmptyBorders(@NonNull X scrollPane) {
        Border empty = BorderFactory.createEmptyBorder();
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBorder(empty);
        return scrollPane;
    }

    public static <X extends JSplitPane> @NonNull X withEmptyBorders(@NonNull X splitPane) {
        Border empty = BorderFactory.createEmptyBorder();
        splitPane.setBorder(empty);
        return splitPane;
    }

    public static @NonNull Border createDropBorder(@NonNull Color color) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createDashedBorder(color, 3.0f, 5.0f, 3.0f, true));
    }
}

