/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.RGB;
import java.awt.Color;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Colors {
    public static @NonNull Color withAlpha(@NonNull Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static @NonNull Color blend(@NonNull Color from, @NonNull Color to, double ratio) {
        return Colors.rgbToColor(RGB.blend(from.getRGB(), to.getRGB(), ratio));
    }

    public static double getLuminance(Color c) {
        return RGB.getLuminance(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static boolean isDark(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        return RGB.isDark(r, g, b);
    }

    public static @NonNull Color rgbToColor(int value) {
        return new Color(value, false);
    }

    public static int colorToRgb(@NonNull Color color) {
        return RGB.rgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static @NonNull String toHex(@NonNull Color color) {
        return RGB.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static @NonNull Color toGray(@NonNull Color color) {
        return Colors.rgbToColor(RGB.toGray(Colors.colorToRgb(color)));
    }

    private Colors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

