/*
 * Decompiled with CFR 0.152.
 */
package internal;

import java.awt.Component;
import java.awt.Graphics;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.Icon;
import lombok.NonNull;

public final class ForwardingIcon
implements Icon {
    @NonNull
    private final Supplier<Icon> delegate;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegate.get().paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.delegate.get().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.delegate.get().getIconHeight();
    }

    public static ForwardingIcon of(BooleanSupplier condition, Icon first, Icon second) {
        return ForwardingIcon.of(() -> condition.getAsBoolean() ? first : second);
    }

    private ForwardingIcon(@NonNull Supplier<Icon> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    public static ForwardingIcon of(@NonNull Supplier<Icon> delegate) {
        return new ForwardingIcon(delegate);
    }
}

