/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.FontIcon;
import java.awt.Font;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class InternalUtil {
    public static final Supplier<Icon> MISSING_ICON = InternalUtil.getLazyResource(InternalUtil::createFallbackIcon);

    public static @NonNull Font resizeByFactor(@NonNull Font font, float factor) {
        return font.deriveFont(font.getSize2D() * factor);
    }

    public static <X> @NonNull Supplier<X> getLazyResource(@NonNull Supplier<X> factory) {
        return new LazyResource<X>(factory);
    }

    private static Icon createFallbackIcon() {
        return FontIcon.of('?', new JLabel().getFont(), null, 0.0);
    }

    private InternalUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class LazyResource<X>
    implements Supplier<X> {
        @lombok.NonNull
        private final Supplier<X> factory;
        private final AtomicReference<X> resource = new AtomicReference();

        @Override
        public X get() {
            X result = this.resource.get();
            if (result == null) {
                result = this.factory.get();
                this.resource.set(result);
            }
            return result;
        }

        public LazyResource(@lombok.NonNull Supplier<X> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.factory = factory;
        }
    }
}

