/*
 * Decompiled with CFR 0.152.
 */
package internal;

import org.checkerframework.checker.nullness.qual.NonNull;

public final class RGB {
    public static int rgb(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int blend(int from, int to, double ratio) {
        float fromRatio = (float)ratio;
        float toRatio = 1.0f - fromRatio;
        float r = (float)(from >> 16 & 0xFF) * fromRatio + (float)(to >> 16 & 0xFF) * toRatio;
        float g = (float)(from >> 8 & 0xFF) * fromRatio + (float)(to >> 8 & 0xFF) * toRatio;
        float b = (float)(from & 0xFF) * fromRatio + (float)(to & 0xFF) * toRatio;
        return RGB.rgb((int)r, (int)g, (int)b);
    }

    public static double getLuminance(int r, int g, int b) {
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public static double colorDistance(double[] color1, double[] color2) {
        return RGB.colorDistance(color1[0], color1[1], color1[2], color2[0], color2[1], color2[2]);
    }

    public static double colorDistance(double r1, double g1, double b1, double r2, double g2, double b2) {
        double a = r2 - r1;
        double b = g2 - g1;
        double c = b2 - b1;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public static boolean isDark(double r, double g, double b) {
        double dWhite = RGB.colorDistance(r, g, b, 1.0, 1.0, 1.0);
        double dBlack = RGB.colorDistance(r, g, b, 0.0, 0.0, 0.0);
        return dBlack < dWhite;
    }

    public static @NonNull String toHex(int rgb) {
        return RGB.toHex(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static @NonNull String toHex(int r, int g, int b) {
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static int toGray(int rgb) {
        float avg = ((float)(rgb >> 16 & 0xFF) / 255.0f + (float)(rgb >> 8 & 0xFF) / 255.0f + (float)(rgb & 0xFF) / 255.0f) / 3.0f;
        float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
        avg = Math.min(1.0f, 0.35f + 0.65f * avg);
        return (int)(alpha * 255.0f) << 24 | (int)(avg * 255.0f) << 16 | (int)(avg * 255.0f) << 8 | (int)(avg * 255.0f);
    }

    private RGB() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

