/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.Animation;
import internal.Animator;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SpinningIcon
implements Icon {
    private static final int DURATION = 2000;
    private final Animation animation = Animation.cycle(2000L, this::refresh);
    private final Icon icon;
    private Component animated;
    private double angle;

    public static @NonNull SpinningIcon of(@NonNull Icon icon) {
        return new SpinningIcon(icon);
    }

    public static @NonNull SpinningIcon of(@NonNull Icon icon, @NonNull Component animated) {
        SpinningIcon result = new SpinningIcon(icon);
        result.init(animated);
        return result;
    }

    private SpinningIcon(Icon icon) {
        this.icon = icon;
        this.animated = null;
        this.angle = 0.0;
    }

    private void refresh(double position) {
        double newAngle = Math.PI * 2 * position;
        if (this.angle != newAngle) {
            this.angle = newAngle;
            if (this.animated != null) {
                this.animated.repaint();
            }
        }
    }

    private void init(Component c) {
        Animator.INSTANCE.register(this.animation);
        this.animated = c;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.animated == null) {
            this.init(c);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AffineTransform trans = new AffineTransform();
        trans.translate(x, y);
        trans.rotate(this.angle, (double)this.getIconWidth() / 2.0, (double)this.getIconHeight() / 2.0);
        g2d.transform(trans);
        this.icon.paintIcon(c, g2d, 0, 0);
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }
}

