/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class XPopup {
    private Popup popup = null;

    public void hide() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void show(@Nullable Component owner, @NonNull Component content, @NonNull Anchor anchor, @NonNull Dimension gap) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (gap == null) {
            throw new NullPointerException("gap is marked non-null but is null");
        }
        if (owner == null || !owner.isShowing()) {
            return;
        }
        this.hide();
        Point location = XPopup.getLocation(owner, content, anchor, gap);
        this.popup = PopupFactory.getSharedInstance().getPopup(owner, content, location.x, location.y);
        this.popup.show();
    }

    private static Rectangle getScreenBounds(GraphicsConfiguration gc) {
        Rectangle result = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        result.x += screenInsets.left;
        result.y += screenInsets.top;
        result.width -= screenInsets.left + screenInsets.right;
        result.height -= screenInsets.top + screenInsets.bottom;
        return result;
    }

    private static Point getLocation(Component owner, Component content, Anchor anchor, Dimension gap) {
        boolean leading;
        Point screenLocation = owner.getLocationOnScreen();
        Point result = new Point();
        Dimension size = content.getPreferredSize();
        boolean above = anchor == Anchor.TOP_LEADING || anchor == Anchor.TOP_TRAILING;
        boolean bl = leading = anchor == Anchor.TOP_LEADING || anchor == Anchor.BOTTOM_LEADING;
        if (!owner.getComponentOrientation().isLeftToRight()) {
            leading = !leading;
        }
        result.y = screenLocation.y + (above ? -size.height - gap.height : owner.getHeight() + gap.height);
        result.x = screenLocation.x + (leading ? gap.width : owner.getWidth() - size.width - gap.width);
        Rectangle screenBounds = XPopup.getScreenBounds(owner.getGraphicsConfiguration());
        if (result.x < screenBounds.x) {
            result.x = screenBounds.x;
        } else if (result.x - screenBounds.x + size.width > screenBounds.width) {
            result.x = screenBounds.x + Math.max(0, screenBounds.width - size.width);
        }
        if (result.y < screenBounds.y) {
            result.y = screenBounds.y;
        } else if (result.y - screenBounds.y + size.height > screenBounds.height) {
            result.y = screenBounds.y + Math.max(0, screenBounds.height - size.height);
        }
        return result;
    }

    public static enum Anchor {
        TOP_LEADING,
        BOTTOM_LEADING,
        TOP_TRAILING,
        BOTTOM_TRAILING;

    }
}

