/*
 * Decompiled with CFR 0.152.
 */
package ec.util.list.swing;

import java.awt.Component;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import lombok.NonNull;

public final class JLists {
    private JLists() {
    }

    @NonNull
    public static <E> Stream<E> stream(@NonNull ListModel<E> model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return IntStream.range(0, model.getSize()).mapToObj(model::getElementAt);
    }

    @NonNull
    public static <E> List<E> asList(@NonNull ListModel<E> model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return new ListAdapter<E>(model);
    }

    @NonNull
    public static <E> ListModel<E> emptyModel() {
        return new EmptyListModel();
    }

    @NonNull
    public static <E> ListModel<E> modelOf(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        return JLists.modelOf(Arrays.asList(elements));
    }

    @NonNull
    public static <E> ListModel<E> modelOf(@NonNull List<E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        return !elements.isEmpty() ? new ListModelImpl<E>(elements) : JLists.emptyModel();
    }

    @NonNull
    public static <E> ListCellRenderer<E> cellRendererOf(@NonNull BiConsumer<JLabel, E> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return new LabelListCellRenderer<Object>((renderer, list, value, index, isSelected, cellHasFocus) -> consumer.accept(renderer, value));
    }

    @NonNull
    public static ListDataListener dataListenerOf(final @NonNull Consumer<ListDataEvent> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                listener.accept(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                listener.accept(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                listener.accept(e);
            }
        };
    }

    @NonNull
    public static IntStream getSelectionIndexStream(@NonNull ListSelectionModel model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return model.isSelectionEmpty() ? IntStream.empty() : IntStream.rangeClosed(model.getMinSelectionIndex(), model.getMaxSelectionIndex()).filter(model::isSelectedIndex);
    }

    public static void setSelectionIndexStream(@NonNull ListSelectionModel model, @NonNull IntStream selection) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (selection == null) {
            throw new NullPointerException("selection is marked non-null but is null");
        }
        model.clearSelection();
        JLists.addSelectionIndexStream(model, selection);
    }

    public static void addSelectionIndexStream(@NonNull ListSelectionModel model, @NonNull IntStream selection) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (selection == null) {
            throw new NullPointerException("selection is marked non-null but is null");
        }
        selection.forEach(x -> model.addSelectionInterval(x, x));
    }

    public static void removeSelectionIndexStream(@NonNull ListSelectionModel model, @NonNull IntStream selection) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (selection == null) {
            throw new NullPointerException("selection is marked non-null but is null");
        }
        selection.forEach(x -> model.removeSelectionInterval(x, x));
    }

    public static int getSelectionIndexSize(@NonNull ListSelectionModel model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return (int)JLists.getSelectionIndexStream(model).count();
    }

    public static boolean isSingleSelectionIndex(@NonNull ListSelectionModel model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return !model.isSelectionEmpty() && model.getMinSelectionIndex() == model.getMaxSelectionIndex();
    }

    static void move(DefaultListModel from, DefaultListModel to, int[] selection, int dropIndex) {
        ArrayList reversedItems = new ArrayList(selection.length);
        for (int i = selection.length - 1; i >= 0; --i) {
            reversedItems.add(from.remove(selection[i]));
        }
        reversedItems.forEach(o -> to.insertElementAt(o, dropIndex));
    }

    private static final class ListAdapter<E>
    extends AbstractList<E> {
        private final ListModel<E> model;

        public ListAdapter(ListModel<E> model) {
            this.model = model;
        }

        @Override
        public E get(int index) {
            return this.model.getElementAt(index);
        }

        @Override
        public int size() {
            return this.model.getSize();
        }
    }

    private static final class EmptyListModel<E>
    extends AbstractListModel<E> {
        private EmptyListModel() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public E getElementAt(int index) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static final class ListModelImpl<E>
    extends AbstractListModel<E> {
        private final List<E> data;

        public ListModelImpl(List<E> data) {
            this.data = data;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public E getElementAt(int index) {
            return this.data.get(index);
        }
    }

    private static final class LabelListCellRenderer<T>
    implements ListCellRenderer<T> {
        private final LabelListCellConsumer<T> consumer;
        private final DefaultListCellRenderer delegate;

        public LabelListCellRenderer(@NonNull LabelListCellConsumer<T> consumer) {
            if (consumer == null) {
                throw new NullPointerException("consumer is marked non-null but is null");
            }
            this.consumer = consumer;
            this.delegate = new DefaultListCellRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.consumer.accept(this.delegate, list, (T)value, index, isSelected, cellHasFocus);
            return this.delegate;
        }

        @FunctionalInterface
        static interface LabelListCellConsumer<T> {
            public void accept(JLabel var1, JList<? extends T> var2, T var3, int var4, boolean var5, boolean var6);
        }
    }
}

