/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import ec.util.various.swing.UIItem;
import internal.InternalUtil;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import lombok.Generated;
import lombok.NonNull;

public enum StandardSwingColor implements UIItem<Color>
{
    TABLE_HEADER_BACKGROUND("TableHeader.background"),
    TABLE_HEADER_FOREGROUND("TableHeader.foreground"),
    TABLE_BACKGROUND("Table.background"),
    TABLE_FOREGROUND("Table.foreground"),
    TABLE_SELECTION_BACKGROUND("Table.selectionBackground"),
    TABLE_SELECTION_FOREGROUND("Table.selectionForeground"),
    TEXT_FIELD_INACTIVE_BACKGROUND("TextField.inactiveBackground"),
    TEXT_FIELD_INACTIVE_FOREGROUND("TextField.inactiveForeground"),
    CONTROL("control");

    private final String key;
    private static final Supplier<JTable> TABLE;
    private static final Supplier<JTextField> TEXT_FIELD;
    private static final Supplier<JPanel> PANEL;

    @Override
    @NonNull
    public String key() {
        return this.key;
    }

    @Override
    public Color value() {
        Color result = null;
        switch (this) {
            case TABLE_HEADER_BACKGROUND: {
                result = TABLE.get().getTableHeader().getBackground();
                break;
            }
            case TABLE_HEADER_FOREGROUND: {
                result = TABLE.get().getTableHeader().getForeground();
                break;
            }
            case TABLE_BACKGROUND: {
                result = TABLE.get().getBackground();
                break;
            }
            case TABLE_FOREGROUND: {
                result = TABLE.get().getForeground();
                break;
            }
            case TABLE_SELECTION_BACKGROUND: {
                result = TABLE.get().getSelectionBackground();
                break;
            }
            case TABLE_SELECTION_FOREGROUND: {
                result = TABLE.get().getSelectionForeground();
                break;
            }
            case TEXT_FIELD_INACTIVE_BACKGROUND: {
                break;
            }
            case TEXT_FIELD_INACTIVE_FOREGROUND: {
                result = TEXT_FIELD.get().getDisabledTextColor();
                break;
            }
            case CONTROL: {
                result = PANEL.get().getBackground();
            }
        }
        return result != null ? result : UIManager.getColor(this.key);
    }

    @Deprecated
    @NonNull
    public Color or(@NonNull Color fallback) {
        Objects.requireNonNull(fallback);
        Color result = this.value();
        return result != null ? result : fallback;
    }

    @Generated
    private StandardSwingColor(String key) {
        this.key = key;
    }

    static {
        TABLE = InternalUtil.getLazyResource(JTable::new);
        TEXT_FIELD = InternalUtil.getLazyResource(JTextField::new);
        PANEL = InternalUtil.getLazyResource(JPanel::new);
    }
}

