/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class TextPrompt
extends JLabel {
    private final JTextComponent component;
    private final Document document;
    private Show show;
    private boolean showPromptOnce;
    private int focusLost;

    public TextPrompt(String text, JTextComponent component) {
        this(text, component, Show.ALWAYS);
    }

    public TextPrompt(String text, JTextComponent component, Show show) {
        this.component = component;
        this.setShow(show);
        this.document = component.getDocument();
        this.setText(text);
        this.setFont(component.getFont());
        this.setForeground(component.getForeground());
        this.setBorder(new EmptyBorder(component.getInsets()));
        this.setHorizontalAlignment(10);
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TextPrompt.this.checkForPrompt();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextPrompt.this.focusLost++;
                TextPrompt.this.checkForPrompt();
            }
        });
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextPrompt.this.checkForPrompt();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextPrompt.this.checkForPrompt();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        component.setLayout(new BorderLayout());
        component.add(this);
        this.checkForPrompt();
    }

    public void changeAlpha(float alpha) {
        this.changeAlpha((int)(alpha * 255.0f));
    }

    public void changeAlpha(int alpha) {
        alpha = alpha > 255 ? 255 : Math.max(alpha, 0);
        Color foreground = this.getForeground();
        int red = foreground.getRed();
        int green = foreground.getGreen();
        int blue = foreground.getBlue();
        Color withAlpha = new Color(red, green, blue, alpha);
        super.setForeground(withAlpha);
    }

    public void changeStyle(int style) {
        this.setFont(this.getFont().deriveFont(style));
    }

    public Show getShow() {
        return this.show;
    }

    public void setShow(Show show) {
        this.show = show;
    }

    public boolean getShowPromptOnce() {
        return this.showPromptOnce;
    }

    public void setShowPromptOnce(boolean showPromptOnce) {
        this.showPromptOnce = showPromptOnce;
    }

    private void checkForPrompt() {
        if (this.document.getLength() > 0) {
            this.setVisible(false);
            return;
        }
        if (this.showPromptOnce && this.focusLost > 0) {
            this.setVisible(false);
            return;
        }
        if (this.component.hasFocus()) {
            this.setVisible(this.show == Show.ALWAYS || this.show == Show.FOCUS_GAINED);
        } else {
            this.setVisible(this.show == Show.ALWAYS || this.show == Show.FOCUS_LOST);
        }
    }

    public static enum Show {
        ALWAYS,
        FOCUS_GAINED,
        FOCUS_LOST;

    }
}

