/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import ec.util.completion.ExtAutoCompletionSource;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public abstract class AbstractAutoCompletionSource<T>
extends ExtAutoCompletionSource
implements Comparator<T> {
    @Override
    @NonNull
    public final String toString(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.getValueAsString(value);
    }

    @Override
    @NonNull
    public AutoCompletionSource.Behavior getBehavior(@NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        return AutoCompletionSource.Behavior.SYNC;
    }

    @Override
    @NonNull
    public List<?> getValues(@NonNull String term) throws Exception {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        return this.getValues(term, this.getAllValues());
    }

    @Override
    @NonNull
    public ExtAutoCompletionSource.Request getRequest(@NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        return AbstractAutoCompletionSource.wrap(this, term);
    }

    @NonNull
    protected abstract Iterable<T> getAllValues() throws Exception;

    @NonNull
    protected String getValueAsString(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.toString();
    }

    @NonNull
    protected String getNormalizedString(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return AutoCompletionSources.normalize(input);
    }

    protected boolean matches(@NonNull String normalizedTerm, @NonNull String normalizedInput) {
        if (normalizedTerm == null) {
            throw new NullPointerException("normalizedTerm is marked non-null but is null");
        }
        if (normalizedInput == null) {
            throw new NullPointerException("normalizedInput is marked non-null but is null");
        }
        return normalizedInput.contains(normalizedTerm);
    }

    protected boolean matches(@NonNull TermMatcher termMatcher, @NonNull T input) {
        if (termMatcher == null) {
            throw new NullPointerException("termMatcher is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return termMatcher.matches(this.getValueAsString(input));
    }

    protected @NonNegative int getLimitSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int compare(T left, T right) {
        return this.getValueAsString(left).compareTo(this.getValueAsString(right));
    }

    @NonNull
    protected List<?> getValues(@NonNull String term, @NonNull Iterable<T> allValues) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        if (allValues == null) {
            throw new NullPointerException("allValues is marked non-null but is null");
        }
        TermMatcher termFilter = this.createTermMatcher(term);
        return StreamSupport.stream(allValues.spliterator(), false).filter(o -> this.matches(termFilter, o)).limit(this.getLimitSize()).sorted(this).collect(Collectors.toList());
    }

    @NonNull
    protected ExtAutoCompletionSource.Request createCachedRequest(final @NonNull String term, final @NonNull Iterable<T> allValues) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        if (allValues == null) {
            throw new NullPointerException("allValues is marked non-null but is null");
        }
        return new ExtAutoCompletionSource.Request(){

            @Override
            @NonNull
            public String getTerm() {
                return term;
            }

            @Override
            @NonNull
            public AutoCompletionSource.Behavior getBehavior() {
                return AutoCompletionSource.Behavior.SYNC;
            }

            @Override
            public List<?> call() throws Exception {
                return AbstractAutoCompletionSource.this.getValues(term, allValues);
            }
        };
    }

    @NonNull
    protected TermMatcher createTermMatcher(@NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        String normalizedTerm = this.getNormalizedString(term);
        return o -> o != null && this.matches(normalizedTerm, this.getNormalizedString(o));
    }

    @FunctionalInterface
    public static interface TermMatcher {
        public boolean matches(@Nullable String var1);
    }
}

