/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;

public final class LineBorder2
implements Border {
    private final Color color;
    private final int left;
    private final int right;
    private final int top;
    private final int bottom;

    public LineBorder2(Color color, int top, int left, int bottom, int right) {
        this.color = color;
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.color);
            Path2D.Float path = new Path2D.Float(0);
            path.append(new Rectangle2D.Float(x, y, width, height), false);
            path.append(new Rectangle2D.Float(x + this.left, y + this.top, width - this.left - this.right, height - this.top - this.bottom), false);
            g2d.fill(path);
            g2d.setColor(oldColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

