/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.Animation;
import java.lang.ref.WeakReference;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;

enum Animator {
    INSTANCE;

    private static final int DEFAULT_FPS = 60;
    private final Clock clock;
    private final Timer timer;
    private final List<WeakReference<Animation>> animations;

    private Animator() {
        this(60, Clock.systemDefaultZone());
    }

    private Animator(int fps, Clock clock) {
        this.clock = clock;
        this.timer = new Timer(1000 / fps, event -> this.broadcast(clock.millis()));
        this.animations = new ArrayList<WeakReference<Animation>>();
        this.timer.start();
    }

    private void broadcast(long currentTimeInMillis) {
        Iterator<WeakReference<Animation>> iterator = this.animations.iterator();
        while (iterator.hasNext()) {
            Animation o = (Animation)iterator.next().get();
            if (o != null && o.refresh(currentTimeInMillis)) continue;
            iterator.remove();
        }
    }

    public void register(Animation animation) {
        if (animation.refresh(this.clock.millis())) {
            this.animations.add(new WeakReference<Animation>(animation));
        }
    }
}

