/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.ExtAutoCompletionSource;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.NonNull;

public final class AutoCompletionSources {
    private static final AutoCompletionSource NONE = ExtAutoCompletionSource.builder(Collections::emptyList).behavior(AutoCompletionSource.Behavior.NONE).build();

    private AutoCompletionSources() {
    }

    @NonNull
    public static AutoCompletionSource empty() {
        return NONE;
    }

    @NonNull
    public static <T> AutoCompletionSource of(boolean strict, T ... list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        return AutoCompletionSources.of(strict, Arrays.asList(list));
    }

    @NonNull
    public static <T> AutoCompletionSource of(boolean strict, @NonNull Iterable<T> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        UnaryOperator normalizer = strict ? UnaryOperator.identity() : AutoCompletionSources::normalize;
        return ExtAutoCompletionSource.builder(term -> {
            String normalizedTerm = (String)normalizer.apply(term);
            return StreamSupport.stream(list.spliterator(), false).filter(o -> o != null && ((String)normalizer.apply(o.toString())).contains(normalizedTerm)).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        }).behavior(AutoCompletionSource.Behavior.SYNC).valueToString(Object::toString).build();
    }

    @NonNull
    public static String removeDiacritics(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    @NonNull
    public static String normalize(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return AutoCompletionSources.removeDiacritics(input).toLowerCase(Locale.ROOT);
    }
}

