/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class FileAutoCompletionSource
implements AutoCompletionSource {
    protected final boolean strict;
    protected final FileFilter fileFilter;
    protected final File[] paths;

    public FileAutoCompletionSource() {
        this(false, null, new File[0]);
    }

    public FileAutoCompletionSource(boolean strict, FileFilter fileFilter, File[] paths) {
        this.strict = strict;
        this.fileFilter = fileFilter;
        this.paths = paths;
    }

    @Override
    @NonNull
    public AutoCompletionSource.Behavior getBehavior(@NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        return AutoCompletionSource.Behavior.ASYNC;
    }

    @Override
    @NonNull
    public String toString(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return ((File)value).getPath();
    }

    @NonNull
    public List<File> getValues(@NonNull String term) throws IOException {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        File file = new File(term);
        if (file.exists() && file.isDirectory()) {
            return FileAutoCompletionSource.children(file, this.fileFilter);
        }
        File parent = file.getParentFile();
        if (parent != null && parent.exists()) {
            return FileAutoCompletionSource.children(parent, this.normalizedFilter(term));
        }
        for (File path : this.paths) {
            File file2 = new File(path, term);
            if (file2.exists() && file2.isDirectory()) {
                return this.toRelativeFiles(FileAutoCompletionSource.children(file2, this.fileFilter), path);
            }
            File parent2 = file2.getParentFile();
            if (parent2 == null || !parent2.exists()) continue;
            return this.toRelativeFiles(FileAutoCompletionSource.children(parent2, this.normalizedFilter(file2.getAbsolutePath())), path);
        }
        return Collections.emptyList();
    }

    List<File> toRelativeFiles(List<File> files, File path) {
        files.replaceAll(file -> new File(file.getPath().substring(path.getPath().length() + 1)));
        return files;
    }

    FileFilter normalizedFilter(String term) {
        String normalizedTerm = this.getNormalizedString(term);
        return o -> (this.fileFilter == null || this.fileFilter.accept(o)) && this.getNormalizedString(o.getPath()).startsWith(normalizedTerm);
    }

    String getNormalizedString(String input) {
        return this.strict ? input : AutoCompletionSources.normalize(input);
    }

    static List<File> children(File folder, FileFilter fileFilter) {
        File[] result = folder.listFiles(fileFilter);
        return result != null ? Arrays.asList(result) : Collections.emptyList();
    }
}

