/*
 * Decompiled with CFR 0.152.
 */
package ec.util.grid.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import lombok.NonNull;

final class FixedColumnTable
implements PropertyChangeListener,
ChangeListener,
TableModelListener {
    private final JTable main;
    private final JTable fixed;
    private final JScrollPane scrollPane;

    public FixedColumnTable(int fixedColumns, JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.main = (JTable)scrollPane.getViewport().getView();
        this.main.setAutoCreateColumnsFromModel(false);
        this.main.addPropertyChangeListener(this);
        this.fixed = new JTable();
        this.fixed.setAutoCreateColumnsFromModel(false);
        this.fixed.setModel(this.main.getModel());
        this.fixed.getModel().addTableModelListener(this);
        this.fixed.setSelectionModel(this.main.getSelectionModel());
        this.fixed.setFocusable(false);
        this.fixed.setAutoResizeMode(0);
        this.fixed.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                FixedColumnTable.this.fixed.setPreferredScrollableViewportSize(FixedColumnTable.this.fixed.getPreferredSize());
            }
        });
        this.makeColumns(fixedColumns);
        this.fixed.setPreferredScrollableViewportSize(this.fixed.getPreferredSize());
        scrollPane.setRowHeaderView(this.fixed);
        scrollPane.setCorner("UPPER_LEFT_CORNER", this.fixed.getTableHeader());
        scrollPane.getRowHeader().addChangeListener(this);
        this.fixed.setRowHeight(this.main.getRowHeight());
    }

    private static void clear(TableColumnModel columnModel) {
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
    }

    private void makeColumns(int fixedColumns) {
        int i;
        FixedColumnTable.clear(this.fixed.getColumnModel());
        FixedColumnTable.clear(this.main.getColumnModel());
        for (i = 0; i < fixedColumns; ++i) {
            this.fixed.addColumn(new TableColumn(i));
        }
        for (i = fixedColumns; i < this.main.getModel().getColumnCount(); ++i) {
            this.main.addColumn(new TableColumn(i));
        }
    }

    @NonNull
    public JTable getFixedTable() {
        return this.fixed;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "selectionModel": {
                this.fixed.setSelectionModel(this.main.getSelectionModel());
                break;
            }
            case "model": {
                this.fixed.getModel().removeTableModelListener(this);
                this.fixed.setModel(this.main.getModel());
                this.fixed.getModel().addTableModelListener(this);
                this.makeColumns(this.fixed.getColumnCount());
                break;
            }
            case "rowHeight": {
                this.fixed.setRowHeight(this.main.getRowHeight());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JViewport viewport = (JViewport)e.getSource();
        this.scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1) {
            this.makeColumns(this.fixed.getColumnCount());
        }
    }
}

