/*
 * Decompiled with CFR 0.152.
 */
package ec.util.table.swing;

import java.awt.Component;
import java.util.function.BiConsumer;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import lombok.Generated;
import lombok.NonNull;

public final class JTables {
    @NonNull
    public static <E> TableCellRenderer cellRendererOf(@NonNull BiConsumer<JLabel, E> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return new LabelTableCellRenderer<E>(consumer);
    }

    public static void setWidthAsPercentages(@NonNull JTable table, double ... percentages) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (percentages == null) {
            throw new NullPointerException("percentages is marked non-null but is null");
        }
        double factor = 10000.0;
        TableColumnModel model = table.getColumnModel();
        for (int columnIndex = 0; columnIndex < percentages.length; ++columnIndex) {
            TableColumn column = model.getColumn(columnIndex);
            column.setPreferredWidth((int)(percentages[columnIndex] * 10000.0));
        }
    }

    @Generated
    private JTables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class LabelTableCellRenderer<T>
    implements TableCellRenderer {
        @NonNull
        private final BiConsumer<JLabel, T> consumer;
        private final DefaultTableCellRenderer delegate = new DefaultTableCellRenderer();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.consumer.accept(this.delegate, (JLabel)value);
            return this.delegate;
        }

        @Generated
        public LabelTableCellRenderer(@NonNull BiConsumer<JLabel, T> consumer) {
            if (consumer == null) {
                throw new NullPointerException("consumer is marked non-null but is null");
            }
            this.consumer = consumer;
        }
    }
}

