/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FontIcon
implements Icon {
    private final char code;
    private final Font font;
    private final int width;
    private final int height;
    private final @Nullable Color color;
    private final double angle;

    @lombok.NonNull
    public static FontIcon of(char code, @lombok.NonNull Font font, int width, int height, @Nullable Color color, double angle) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        return new FontIcon(code, font, width, height, color, angle);
    }

    @lombok.NonNull
    public static FontIcon of(char code, @lombok.NonNull Font font, @Nullable Color color, double angle) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        Dimension iconSize = FontIcon.getIconSize(code, font);
        return new FontIcon(code, font, iconSize.width, iconSize.height, color, angle);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create(x, y, this.width, this.height);
        g2d.setFont(this.font);
        g2d.setColor(this.getColor(c));
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Point2D.Float position = this.getCharPosition(g2d);
        if (this.angle != 0.0) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(Math.toRadians(this.angle), (float)this.width / 2.0f, (float)this.height / 2.0f);
            g2d.transform(trans);
        }
        g2d.drawString(String.valueOf(this.code), position.x, position.y);
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    private Color getColor(Component c) {
        Color foreground = this.color != null ? this.color : c.getForeground();
        return c.isEnabled() ? foreground : Colors.toGray(foreground);
    }

    private Point2D.Float getCharPosition(Graphics2D g2d) {
        AffineTransform savedTransform = g2d.getTransform();
        g2d.setTransform(new AffineTransform());
        FontMetrics fm = g2d.getFontMetrics();
        float x = (float)(this.width - fm.charWidth(this.code)) / 2.0f;
        float y = (float)fm.getAscent() + (float)(fm.getHeight() - (fm.getAscent() + fm.getDescent())) / 2.0f;
        g2d.setTransform(savedTransform);
        return new Point2D.Float(x, y);
    }

    private static Dimension getIconSize(char code, Font font) {
        JLabel label = new JLabel(String.valueOf(code));
        label.setFont(font);
        return label.getPreferredSize();
    }

    @Generated
    public @NonNull FontIcon withCode(char code) {
        return this.code == code ? this : new FontIcon(code, this.font, this.width, this.height, this.color, this.angle);
    }

    @Generated
    public @NonNull FontIcon withFont(Font font) {
        return this.font == font ? this : new FontIcon(this.code, font, this.width, this.height, this.color, this.angle);
    }

    @Generated
    public @NonNull FontIcon withWidth(int width) {
        return this.width == width ? this : new FontIcon(this.code, this.font, width, this.height, this.color, this.angle);
    }

    @Generated
    public @NonNull FontIcon withHeight(int height) {
        return this.height == height ? this : new FontIcon(this.code, this.font, this.width, height, this.color, this.angle);
    }

    @Generated
    public @NonNull FontIcon withColor(@Nullable Color color) {
        return this.color == color ? this : new FontIcon(this.code, this.font, this.width, this.height, color, this.angle);
    }

    @Generated
    public @NonNull FontIcon withAngle(double angle) {
        return this.angle == angle ? this : new FontIcon(this.code, this.font, this.width, this.height, this.color, angle);
    }

    @Generated
    private FontIcon(char code, Font font, int width, int height, @Nullable Color color, double angle) {
        this.code = code;
        this.font = font;
        this.width = width;
        this.height = height;
        this.color = color;
        this.angle = angle;
    }
}

