/*
 * Decompiled with CFR 0.152.
 */
package internal;

import ec.util.various.swing.UIItem;
import internal.FontIcon;
import internal.InternalUtil;
import java.awt.Font;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ToolBarIcon implements UIItem<Icon>
{
    MOVE_UP("ToolBar.moveUpIcon"),
    MOVE_DOWN("ToolBar.moveDownIcon"),
    MOVE_LEFT("ToolBar.moveLeftIcon"),
    MOVE_RIGHT("ToolBar.moveRightIcon"),
    MOVE_ALL_UP("ToolBar.moveAllUpIcon"),
    MOVE_ALL_DOWN("ToolBar.moveAllDownIcon"),
    MOVE_ALL_LEFT("ToolBar.moveAllLeftIcon"),
    MOVE_ALL_RIGHT("ToolBar.moveAllRightIcon"),
    MOVE_HORIZONTALLY("ToolBar.moveHorizontallyIcon"),
    MOVE_VERTICALLY("ToolBar.moveVerticallyIcon");

    private final String key;

    @Override
    @NonNull
    public String key() {
        return this.key;
    }

    @Override
    public Icon value() {
        return UIManager.getIcon(this.key);
    }

    public void put(@Nullable Icon icon) {
        UIManager.put(this.key, icon);
    }

    private static void registerDefaultValues() {
        Supplier<Font> font = InternalUtil.getLazyResource(() -> new JToolBar().getFont());
        ToolBarIcon.putIfAbsent("ToolBar.moveUpIcon", '\u2b61', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveDownIcon", '\u2b63', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveLeftIcon", '\u2b60', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveRightIcon", '\u2b62', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveAllUpIcon", '\u21d1', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveAllDownIcon", '\u21d3', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveAllLeftIcon", '\u21d0', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveAllRightIcon", '\u21d2', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveHorizontallyIcon", '\u21c4', font);
        ToolBarIcon.putIfAbsent("ToolBar.moveVerticallyIcon", '\u21c5', font);
    }

    private static void putIfAbsent(String key, char fallback, Supplier<Font> font) {
        if (UIManager.get(key) == null) {
            UIManager.put(key, FontIcon.of(fallback, InternalUtil.resizeByFactor(font.get(), 2.0f), null, 0.0));
        }
    }

    @Generated
    private ToolBarIcon(String key) {
        this.key = key;
    }

    static {
        ToolBarIcon.registerDefaultValues();
    }
}

