/*
 * Decompiled with CFR 0.152.
 */
package ec.util.grid;

import java.util.Objects;
import lombok.NonNull;
import org.checkerframework.checker.index.qual.NonNegative;

public final class CellIndex {
    @NonNull
    public static final CellIndex NULL = new CellIndex(-1, -1);
    private final int row;
    private final int column;

    @NonNull
    public static CellIndex valueOf(int row, int column) {
        return row < 0 || column < 0 ? NULL : new CellIndex(row, column);
    }

    private CellIndex(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public @NonNegative int getRow() {
        return this.row;
    }

    public @NonNegative int getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hash(this.row, this.column);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CellIndex && this.equals((CellIndex)obj);
    }

    private boolean equals(CellIndex that) {
        return this.equals(that.row, that.column);
    }

    public boolean equals(int row, int column) {
        return this.row == row && this.column == column;
    }

    public String toString() {
        return this.row + "x" + this.column;
    }
}

