/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import lombok.NonNull;

public final class ModernUI {
    private ModernUI() {
    }

    @NonNull
    public static <X extends JScrollPane> X withEmptyBorders(@NonNull X scrollPane) {
        if (scrollPane == null) {
            throw new NullPointerException("scrollPane is marked non-null but is null");
        }
        Border empty = BorderFactory.createEmptyBorder();
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBorder(empty);
        return scrollPane;
    }

    @NonNull
    public static <X extends JSplitPane> X withEmptyBorders(@NonNull X splitPane) {
        if (splitPane == null) {
            throw new NullPointerException("splitPane is marked non-null but is null");
        }
        Border empty = BorderFactory.createEmptyBorder();
        splitPane.setBorder(empty);
        return splitPane;
    }

    @NonNull
    public static Border createDropBorder(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createDashedBorder(color, 3.0f, 5.0f, 3.0f, true));
    }
}

