/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public abstract class PopupMouseAdapter
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    protected void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    protected abstract void showPopup(MouseEvent var1);

    public static PopupMouseAdapter fromMenu(JMenu menu) {
        return PopupMouseAdapter.fromPopupMenu(menu.getPopupMenu());
    }

    public static PopupMouseAdapter fromPopupMenu(final JPopupMenu popup) {
        return new PopupMouseAdapter(){

            @Override
            protected void showPopup(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        };
    }
}

