/*
 * Decompiled with CFR 0.152.
 */
package ec.util.grid.swing;

import ec.util.grid.CellIndex;
import ec.util.grid.swing.GridModel;
import ec.util.grid.swing.GridModels;
import ec.util.grid.swing.XTable;
import ec.util.various.swing.StandardSwingColor;
import java.awt.Color;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AGrid
extends JComponent {
    public static final String MODEL_PROPERTY = "model";
    public static final String ROW_SELECTION_ALLOWED_PROPERTY = "rowSelectionAllowed";
    public static final String COLUMN_SELECTION_ALLOWED_PROPERTY = "columnSelectionAllowed";
    public static final String HOVERED_CELL_PROPERTY = "hoveredCell";
    public static final String SELECTED_CELL_PROPERTY = "selectedCell";
    public static final String CROSSHAIR_VISIBLE_PROPERTY = "crosshairVisible";
    public static final String DRAG_ENABLED_PROPERTY = "dragEnabled";
    public static final String GRID_COLOR_PROPERTY = "gridColor";
    public static final String NO_DATA_RENDERER_PROPERTY = "noDataRenderer";
    public static final String ROW_SELECTION_MODEL_PROPERTY = "rowSelectionModel";
    public static final String COLUMN_SELECTION_MODEL_PROPERTY = "columnSelectionModel";
    private static final GridModel DEFAULT_MODEL = GridModels.empty();
    private static final boolean DEFAULT_ROW_SELECTION_ALLOWED = true;
    private static final boolean DEFAULT_COLUMN_SELECTION_ALLOWED = false;
    private static final CellIndex DEFAULT_HOVERED_CELL = CellIndex.NULL;
    private static final CellIndex DEFAULT_SELECTED_CELL = CellIndex.NULL;
    private static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    private static final boolean DEFAULT_DRAG_ENABLED = false;
    private static final XTable.NoDataRenderer DEFAULT_NO_DATA_RENDERER = new XTable.DefaultNoDataRenderer();
    protected GridModel model = DEFAULT_MODEL;
    protected boolean rowSelectionAllowed = true;
    protected boolean columnSelectionAllowed = false;
    protected CellIndex hoveredCell = DEFAULT_HOVERED_CELL;
    protected CellIndex selectedCell = DEFAULT_SELECTED_CELL;
    protected boolean crosshairVisible = false;
    protected boolean dragEnabled = false;
    protected Color gridColor = StandardSwingColor.CONTROL.lookup().orElse(Color.LIGHT_GRAY);
    protected XTable.NoDataRenderer noDataRenderer = DEFAULT_NO_DATA_RENDERER;
    protected ListSelectionModel rowSelectionModel = new DefaultListSelectionModel();
    protected ListSelectionModel columnSelectionModel = new DefaultListSelectionModel();

    @NonNull
    public GridModel getModel() {
        return this.model;
    }

    public void setModel(@Nullable GridModel model) {
        GridModel old = this.model;
        this.model = model != null ? model : DEFAULT_MODEL;
        this.firePropertyChange(MODEL_PROPERTY, old, this.model);
    }

    public boolean isRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
        boolean old = this.rowSelectionAllowed;
        this.rowSelectionAllowed = rowSelectionAllowed;
        this.firePropertyChange(ROW_SELECTION_ALLOWED_PROPERTY, old, this.rowSelectionAllowed);
    }

    public boolean isColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
        boolean old = this.columnSelectionAllowed;
        this.columnSelectionAllowed = columnSelectionAllowed;
        this.firePropertyChange(COLUMN_SELECTION_ALLOWED_PROPERTY, old, this.columnSelectionAllowed);
    }

    @NonNull
    public CellIndex getHoveredCell() {
        return this.hoveredCell;
    }

    public void setHoveredCell(@Nullable CellIndex hoveredCell) {
        CellIndex old = this.hoveredCell;
        this.hoveredCell = hoveredCell != null ? hoveredCell : DEFAULT_HOVERED_CELL;
        this.firePropertyChange(HOVERED_CELL_PROPERTY, old, this.hoveredCell);
    }

    @NonNull
    public CellIndex getSelectedCell() {
        return this.selectedCell;
    }

    public void setSelectedCell(@Nullable CellIndex selectedCell) {
        CellIndex old = this.selectedCell;
        this.selectedCell = selectedCell != null ? selectedCell : DEFAULT_SELECTED_CELL;
        this.firePropertyChange(SELECTED_CELL_PROPERTY, old, this.selectedCell);
    }

    public boolean isCrosshairVisible() {
        return this.crosshairVisible;
    }

    public void setCrosshairVisible(boolean crosshairVisible) {
        boolean old = this.crosshairVisible;
        this.crosshairVisible = crosshairVisible;
        this.firePropertyChange(CROSSHAIR_VISIBLE_PROPERTY, old, this.crosshairVisible);
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        boolean old = this.dragEnabled;
        this.dragEnabled = dragEnabled;
        this.firePropertyChange(DRAG_ENABLED_PROPERTY, old, this.dragEnabled);
    }

    @NonNull
    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(@Nullable Color gridColor) {
        Color old = this.gridColor;
        this.gridColor = gridColor != null ? gridColor : StandardSwingColor.CONTROL.lookup().orElse(Color.LIGHT_GRAY);
        this.firePropertyChange(GRID_COLOR_PROPERTY, old, this.gridColor);
    }

    public  @NonNull XTable.NoDataRenderer getNoDataRenderer() {
        return this.noDataRenderer;
    }

    public void setNoDataRenderer( @Nullable XTable.NoDataRenderer renderer) {
        XTable.NoDataRenderer old = this.noDataRenderer;
        this.noDataRenderer = renderer != null ? renderer : DEFAULT_NO_DATA_RENDERER;
        this.firePropertyChange(NO_DATA_RENDERER_PROPERTY, old, this.noDataRenderer);
    }

    @NonNull
    public ListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    public void setRowSelectionModel(@Nullable ListSelectionModel rowSelectionModel) {
        ListSelectionModel old = this.rowSelectionModel;
        this.rowSelectionModel = rowSelectionModel != null ? rowSelectionModel : new DefaultListSelectionModel();
        this.firePropertyChange(ROW_SELECTION_MODEL_PROPERTY, old, this.rowSelectionModel);
    }

    @NonNull
    public ListSelectionModel getColumnSelectionModel() {
        return this.columnSelectionModel;
    }

    public void setColumnSelectionModel(@Nullable ListSelectionModel columnSelectionModel) {
        ListSelectionModel old = this.columnSelectionModel;
        this.columnSelectionModel = columnSelectionModel != null ? columnSelectionModel : new DefaultListSelectionModel();
        this.firePropertyChange(COLUMN_SELECTION_MODEL_PROPERTY, old, this.columnSelectionModel);
    }
}

