/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion.swing;

import ec.util.completion.swing.CustomListCellRenderer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.Timer;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileListCellRenderer
extends CustomListCellRenderer<File> {
    private final Icon defaultIcon;
    private final FailSafeFactory iconFactory;
    private final File[] paths;

    public FileListCellRenderer(@NonNull ExecutorService executor) {
        this(null, executor, new File[0]);
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    public FileListCellRenderer(@Nullable Icon defaultIcon, @NonNull ExecutorService executor, @NonNull File[] paths) {
        super(false);
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        this.defaultIcon = defaultIcon;
        WellTimedFactory wellTimed = new WellTimedFactory(executor, 20L, TimeUnit.MILLISECONDS);
        SkippingFactory skipping = new SkippingFactory(wellTimed, 40L, TimeUnit.MILLISECONDS);
        this.iconFactory = new DejaVuFactory(skipping, new DefaultFilter(30L, TimeUnit.SECONDS));
        this.paths = paths;
    }

    @Override
    protected Icon toIcon(String term, JList list, File value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!value.isAbsolute()) {
            for (File path : this.paths) {
                try {
                    Path tmp = path.toPath().resolve(value.getPath());
                    if (Files.exists(tmp, new LinkOption[0])) {
                        this.setToolTipText(tmp.toString());
                        return this.iconFactory.create(new IconTask(tmp.toFile()), this.defaultIcon);
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        this.setToolTipText(value.getPath());
        return this.iconFactory.create(new IconTask(value), this.defaultIcon);
    }

    static class WellTimedFactory
    implements FailSafeFactory {
        final ExecutorService executor;
        final long timeout;
        final TimeUnit unit;

        public WellTimedFactory(ExecutorService executor, long timeout, TimeUnit unit) {
            this.executor = executor;
            this.timeout = timeout;
            this.unit = unit;
        }

        @Override
        public <V> V create(Callable<V> task, V defaultValue) {
            try {
                return this.executor.submit(task).get(this.timeout, this.unit);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                return defaultValue;
            }
        }
    }

    static class SkippingFactory
    implements FailSafeFactory {
        final FailSafeFactory factory;
        final long delay;
        final TimeUnit unit;
        long latestErrorTime;

        public SkippingFactory(FailSafeFactory factory, long delay, TimeUnit unit) {
            this.factory = factory;
            this.delay = delay;
            this.unit = unit;
            this.latestErrorTime = 0L;
        }

        @Override
        public <V> V create(Callable<V> task, V defaultValue) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.latestErrorTime < this.unit.convert(this.delay, TimeUnit.MILLISECONDS)) {
                return defaultValue;
            }
            V result = this.factory.create(task, defaultValue);
            if (result == defaultValue) {
                this.latestErrorTime = currentTime;
            }
            return result;
        }
    }

    static interface FailSafeFactory {
        public <V> V create(Callable<V> var1, V var2);
    }

    static class DejaVuFactory
    implements FailSafeFactory {
        final FailSafeFactory factory;
        final Set<Callable<?>> filter;

        public DejaVuFactory(FailSafeFactory factory, Set<Callable<?>> filter) {
            this.factory = factory;
            this.filter = filter;
        }

        @Override
        public <V> V create(Callable<V> task, V defaultValue) {
            if (this.filter.contains(task)) {
                try {
                    return task.call();
                }
                catch (Exception ex) {
                    return defaultValue;
                }
            }
            V result = this.factory.create(task, defaultValue);
            if (result != defaultValue) {
                this.filter.add(task);
            }
            return result;
        }
    }

    static class DefaultFilter<Object>
    extends HashSet<Callable<Object>> {
        final Timer evictor;

        DefaultFilter(long delay, TimeUnit unit) {
            this.evictor = new Timer((int)TimeUnit.MILLISECONDS.convert(delay, unit), evt -> this.clear());
            this.evictor.setRepeats(false);
        }

        @Override
        public boolean add(Callable<Object> e) {
            this.evictor.restart();
            return super.add(e);
        }
    }

    static class IconTask
    implements Callable<Icon> {
        static final JFileChooser FILE_CHOOSER = new JFileChooser();
        final File file;

        public IconTask(File file) {
            this.file = file;
        }

        @Override
        public Icon call() {
            return FILE_CHOOSER.getIcon(this.file);
        }

        public boolean equals(Object obj) {
            return (this == obj || obj instanceof IconTask) && this.equals((IconTask)obj);
        }

        protected boolean equals(IconTask other) {
            return this.file.equals(other.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }
}

