/*
 * Decompiled with CFR 0.152.
 */
package ec.util.list.swing;

import ec.util.datatransfer.LocalDataTransfer;
import ec.util.list.swing.JLists;
import ec.util.various.swing.JCommand;
import internal.ForwardingIcon;
import internal.InternalUtil;
import internal.ToolBarIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataListener;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JListSelection<E>
extends JComponent {
    public static final String SOURCE_MODEL_PROPERTY = "sourceModel";
    public static final String SOURCE_FOOTER_PROPERTY = "sourceFooter";
    public static final String SOURCE_HEADER_PROPERTY = "sourceHeader";
    public static final String TARGET_MODEL_PROPERTY = "targetModel";
    public static final String TARGET_FOOTER_PROPERTY = "targetFooter";
    public static final String TARGET_HEADER_PROPERTY = "targetHeader";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String SELECT_ACTION = "select";
    public static final String UNSELECT_ACTION = "unselect";
    public static final String SELECT_ALL_ACTION = "selectAll";
    public static final String UNSELECT_ALL_ACTION = "unselectAll";
    public static final String INVERT_ACTION = "invert";
    public static final String APPLY_HORIZONTAL_ACTION = "applyHorizontal";
    public static final String APPLY_VERTICAL_ACTION = "applyVertical";
    private final JPanel sourcePanel = new JPanel();
    private final JList<E> sourceList = new JList();
    private final JPanel targetPanel = new JPanel();
    private final JList<E> targetList = new JList();
    private JToolBar toolBar = new JToolBar();
    private DefaultListModel<E> sourceModel = new DefaultListModel();
    private Component sourceFooter = null;
    private Component sourceHeader = null;
    private DefaultListModel<E> targetModel = new DefaultListModel();
    private Component targetFooter = null;
    private Component targetHeader = null;
    private ListCellRenderer<? super E> cellRenderer = new DefaultListCellRenderer();
    private int orientation = 0;

    public JListSelection() {
        this.initComponents();
        this.enableProperties();
        this.enableSelectionOnDoubleClick();
    }

    private void initComponents() {
        ActionMap am = this.getActionMap();
        am.put(SELECT_ACTION, new SelectCommand().toAction(this));
        am.put(UNSELECT_ACTION, new UnselectCommand().toAction(this));
        am.put(SELECT_ALL_ACTION, new SelectAllCommand().toAction(this));
        am.put(UNSELECT_ALL_ACTION, new UnselectAllCommand().toAction(this));
        am.put(INVERT_ACTION, new InvertCommand().toAction(this));
        am.put(APPLY_HORIZONTAL_ACTION, new ApplyHorizontalCommand().toAction(this));
        am.put(APPLY_VERTICAL_ACTION, new ApplyVerticalCommand().toAction(this));
        CustomTransferHandler transferHandler = new CustomTransferHandler(this.sourceList, this.targetList);
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.sourceList.setDragEnabled(true);
        this.sourceList.setDropMode(DropMode.INSERT);
        this.sourceList.setTransferHandler(transferHandler);
        this.sourceList.getInputMap().put(enterKeyStroke, SELECT_ACTION);
        this.sourceList.getActionMap().put(SELECT_ACTION, am.get(SELECT_ACTION));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePanel.add((Component)new JScrollPane(this.sourceList), "Center");
        this.sourcePanel.setPreferredSize(new Dimension(10, 10));
        this.targetList.setDragEnabled(true);
        this.targetList.setDropMode(DropMode.INSERT);
        this.targetList.setTransferHandler(transferHandler);
        this.targetList.getInputMap().put(enterKeyStroke, UNSELECT_ACTION);
        this.targetList.getActionMap().put(UNSELECT_ACTION, am.get(UNSELECT_ACTION));
        this.targetPanel.setLayout(new BorderLayout());
        this.targetPanel.add((Component)new JScrollPane(this.targetList), "Center");
        this.targetPanel.setPreferredSize(new Dimension(10, 10));
        this.toolBar = this.createToolBar();
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolBar.setFloatable(false);
        this.onSourceModelChange();
        this.onTargetModelChange();
        this.onCellRendererChange();
        this.onOrientationChange();
    }

    private void enableProperties() {
        this.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "sourceModel": {
                    this.onSourceModelChange();
                    break;
                }
                case "targetModel": {
                    this.onTargetModelChange();
                    break;
                }
                case "cellRenderer": {
                    this.onCellRendererChange();
                    break;
                }
                case "orientation": {
                    this.onOrientationChange();
                    break;
                }
                case "sourceFooter": {
                    this.onSourcePanelChange();
                    break;
                }
                case "sourceHeader": {
                    this.onSourcePanelChange();
                    break;
                }
                case "targetFooter": {
                    this.onTargetPanelChange();
                    break;
                }
                case "targetHeader": {
                    this.onTargetPanelChange();
                    break;
                }
                case "componentPopupMenu": {
                    this.onComponentPopupMenuChange();
                }
            }
        });
    }

    private void enableSelectionOnDoubleClick() {
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    JListSelection.this.getActionMap().get(JListSelection.SELECT_ACTION).actionPerformed(null);
                }
            }
        });
        this.targetList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    JListSelection.this.getActionMap().get(JListSelection.UNSELECT_ACTION).actionPerformed(null);
                }
            }
        });
    }

    private void onSourceModelChange() {
        this.sourceList.setModel(this.sourceModel);
    }

    private void onTargetModelChange() {
        this.targetList.setModel(this.targetModel);
    }

    private void onCellRendererChange() {
        this.sourceList.setCellRenderer(this.cellRenderer);
        this.targetList.setCellRenderer(this.cellRenderer);
    }

    private void onOrientationChange() {
        this.removeAll();
        boolean horizontal = this.isHorizontal();
        this.toolBar.setOrientation(horizontal ? 1 : 0);
        this.setLayout(new BoxLayout(this, horizontal ? 0 : 1));
        Stream.of(this.sourcePanel, this.toolBar, this.targetPanel).forEach(x$0 -> this.add((Component)x$0));
        this.validate();
    }

    private void onComponentPopupMenuChange() {
        JPopupMenu popupMenu = this.getComponentPopupMenu();
        Stream.of(this.sourcePanel, this.sourceList, this.targetPanel, this.targetList).forEach(o -> o.setComponentPopupMenu(popupMenu));
    }

    private void onSourcePanelChange() {
        this.sourcePanel.removeAll();
        this.sourcePanel.add((Component)new JScrollPane(this.sourceList), "Center");
        if (this.sourceFooter != null) {
            this.sourcePanel.add(this.sourceFooter, "South");
        }
        if (this.sourceHeader != null) {
            this.sourcePanel.add(this.sourceHeader, "North");
        }
        this.sourcePanel.validate();
    }

    private void onTargetPanelChange() {
        this.targetPanel.removeAll();
        this.targetPanel.add((Component)new JScrollPane(this.targetList), "Center");
        if (this.targetFooter != null) {
            this.targetPanel.add(this.targetFooter, "South");
        }
        if (this.targetHeader != null) {
            this.targetPanel.add(this.targetHeader, "North");
        }
        this.targetPanel.validate();
    }

    @NonNull
    public DefaultListModel<E> getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(@Nullable DefaultListModel<E> sourceModel) {
        DefaultListModel<E> old = this.sourceModel;
        this.sourceModel = sourceModel != null ? sourceModel : new DefaultListModel();
        this.firePropertyChange(SOURCE_MODEL_PROPERTY, old, this.sourceModel);
    }

    @NonNull
    public DefaultListModel<E> getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(@Nullable DefaultListModel<E> targetModel) {
        DefaultListModel<E> old = this.targetModel;
        this.targetModel = targetModel != null ? targetModel : new DefaultListModel();
        this.firePropertyChange(SOURCE_MODEL_PROPERTY, old, this.targetModel);
    }

    @NonNull
    public ListCellRenderer<? super E> getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(@Nullable ListCellRenderer<? super E> cellRenderer) {
        ListCellRenderer<? super E> old = this.cellRenderer;
        this.cellRenderer = cellRenderer != null ? cellRenderer : new DefaultListCellRenderer();
        this.firePropertyChange(CELL_RENDERER_PROPERTY, old, this.cellRenderer);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException();
        }
        int old = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange(ORIENTATION_PROPERTY, old, this.orientation);
    }

    public @Nullable Component getSourceFooter() {
        return this.sourceFooter;
    }

    public void setSourceFooter(@Nullable Component sourceFooter) {
        Component old = this.sourceFooter;
        this.sourceFooter = sourceFooter;
        this.firePropertyChange(SOURCE_FOOTER_PROPERTY, old, this.sourceFooter);
    }

    public @Nullable Component getSourceHeader() {
        return this.sourceHeader;
    }

    public void setSourceHeader(@Nullable Component sourceHeader) {
        Component old = this.sourceHeader;
        this.sourceHeader = sourceHeader;
        this.firePropertyChange(SOURCE_HEADER_PROPERTY, old, this.sourceHeader);
    }

    public @Nullable Component getTargetFooter() {
        return this.targetFooter;
    }

    public void setTargetFooter(@Nullable Component targetFooter) {
        Component old = this.targetFooter;
        this.targetFooter = targetFooter;
        this.firePropertyChange(TARGET_FOOTER_PROPERTY, old, this.targetFooter);
    }

    public @Nullable Component getTargetHeader() {
        return this.targetHeader;
    }

    public void setTargetHeader(@Nullable Component targetHeader) {
        Component old = this.targetHeader;
        this.targetHeader = targetHeader;
        this.firePropertyChange(TARGET_HEADER_PROPERTY, old, this.targetHeader);
    }

    @NonNull
    public List<E> getSelectedValues() {
        return JLists.stream(this.targetModel).collect(Collectors.toList());
    }

    public JToolBar createToolBar() {
        ActionMap am = this.getActionMap();
        JToolBar result = new JToolBar();
        result.add(am.get(SELECT_ACTION)).setIcon(this.iconOf(ToolBarIcon.MOVE_RIGHT, ToolBarIcon.MOVE_DOWN));
        result.add(am.get(UNSELECT_ACTION)).setIcon(this.iconOf(ToolBarIcon.MOVE_LEFT, ToolBarIcon.MOVE_UP));
        result.add(am.get(SELECT_ALL_ACTION)).setIcon(this.iconOf(ToolBarIcon.MOVE_ALL_RIGHT, ToolBarIcon.MOVE_ALL_DOWN));
        result.add(am.get(UNSELECT_ALL_ACTION)).setIcon(this.iconOf(ToolBarIcon.MOVE_ALL_LEFT, ToolBarIcon.MOVE_ALL_UP));
        result.add(am.get(INVERT_ACTION)).setIcon(this.iconOf(ToolBarIcon.MOVE_HORIZONTALLY, ToolBarIcon.MOVE_VERTICALLY));
        return result;
    }

    public JPopupMenu createPopupMenu() {
        ActionMap am = this.getActionMap();
        JMenu result = new JMenu();
        result.add(am.get(SELECT_ACTION)).setText("Select");
        result.add(am.get(UNSELECT_ACTION)).setText("Unselect");
        result.add(am.get(SELECT_ALL_ACTION)).setText("Select all");
        result.add(am.get(UNSELECT_ALL_ACTION)).setText("Unselect all");
        result.add(am.get(INVERT_ACTION)).setText("Invert");
        return result.getPopupMenu();
    }

    private Icon iconOf(ToolBarIcon hIcon, ToolBarIcon vIcon) {
        return ForwardingIcon.of(this::isHorizontal, hIcon.lookup().orElseGet(InternalUtil.MISSING_ICON), vIcon.lookup().orElseGet(InternalUtil.MISSING_ICON));
    }

    private boolean isHorizontal() {
        return this.orientation == 0;
    }

    private static void addListDataListener(JCommand.ActionAdapter action, JList<?> list) {
        ListDataListener listener = JLists.dataListenerOf(o -> action.refreshActionState());
        list.getModel().addListDataListener(listener);
        list.addPropertyChangeListener("model", evt -> {
            ((ListModel)evt.getOldValue()).removeListDataListener(listener);
            ((ListModel)evt.getNewValue()).addListDataListener(listener);
            action.refreshActionState();
        });
    }

    private static final class SelectCommand<T>
    extends JCommand<JListSelection<T>> {
        private SelectCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<T> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            int[] selection = JLists.getSelectionIndexStream(((JListSelection)c).sourceList.getSelectionModel()).toArray();
            ((JListSelection)c).sourceList.getSelectionModel().clearSelection();
            ((JListSelection)c).targetList.getSelectionModel().clearSelection();
            int position = ((JListSelection)c).targetModel.size();
            for (int i = selection.length - 1; i >= 0; --i) {
                ((JListSelection)c).targetModel.insertElementAt(((JListSelection)c).sourceModel.remove(selection[i]), position);
            }
            ((JListSelection)c).targetList.getSelectionModel().setSelectionInterval(((JListSelection)c).targetModel.getSize() - selection.length, ((JListSelection)c).targetModel.getSize() - 1);
        }

        @Override
        public boolean isEnabled(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return !((JListSelection)c).sourceList.getSelectionModel().isSelectionEmpty();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return super.toAction(c).withWeakListSelectionListener(((JListSelection)c).sourceList.getSelectionModel());
        }
    }

    private static final class UnselectCommand<T>
    extends JCommand<JListSelection<T>> {
        private UnselectCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<T> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            int[] selection = JLists.getSelectionIndexStream(((JListSelection)c).targetList.getSelectionModel()).toArray();
            ((JListSelection)c).sourceList.getSelectionModel().clearSelection();
            ((JListSelection)c).targetList.getSelectionModel().clearSelection();
            int position = ((JListSelection)c).sourceModel.size();
            for (int i = selection.length - 1; i >= 0; --i) {
                ((JListSelection)c).sourceModel.insertElementAt(((JListSelection)c).targetModel.remove(selection[i]), position);
            }
            ((JListSelection)c).sourceList.getSelectionModel().setSelectionInterval(((JListSelection)c).sourceModel.getSize() - selection.length, ((JListSelection)c).sourceModel.getSize() - 1);
        }

        @Override
        public boolean isEnabled(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return !((JListSelection)c).targetList.getSelectionModel().isSelectionEmpty();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return super.toAction(c).withWeakListSelectionListener(((JListSelection)c).targetList.getSelectionModel());
        }
    }

    private static final class SelectAllCommand<T>
    extends JCommand<JListSelection<T>> {
        private SelectAllCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<T> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            ((JListSelection)c).sourceList.getSelectionModel().clearSelection();
            ((JListSelection)c).targetList.getSelectionModel().clearSelection();
            while (!((JListSelection)c).sourceModel.isEmpty()) {
                ((JListSelection)c).targetModel.addElement(((JListSelection)c).sourceModel.remove(0));
            }
        }

        @Override
        public boolean isEnabled(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return !((JListSelection)c).sourceModel.isEmpty();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            JCommand.ActionAdapter result = super.toAction(c);
            JListSelection.addListDataListener(result, ((JListSelection)c).sourceList);
            return result;
        }
    }

    private static final class UnselectAllCommand<T>
    extends JCommand<JListSelection<T>> {
        private UnselectAllCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<T> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            ((JListSelection)c).sourceList.getSelectionModel().clearSelection();
            ((JListSelection)c).targetList.getSelectionModel().clearSelection();
            while (!((JListSelection)c).targetModel.isEmpty()) {
                ((JListSelection)c).sourceModel.addElement(((JListSelection)c).targetModel.remove(0));
            }
        }

        @Override
        public boolean isEnabled(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return !((JListSelection)c).targetModel.isEmpty();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            JCommand.ActionAdapter result = super.toAction(c);
            JListSelection.addListDataListener(result, ((JListSelection)c).targetList);
            return result;
        }
    }

    private static final class InvertCommand<T>
    extends JCommand<JListSelection<T>> {
        private InvertCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<T> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            List items = JLists.stream(((JListSelection)c).sourceModel).collect(Collectors.toList());
            int[] sourceSelection = JLists.getSelectionIndexStream(((JListSelection)c).sourceList.getSelectionModel()).toArray();
            int[] targetSelection = JLists.getSelectionIndexStream(((JListSelection)c).targetList.getSelectionModel()).toArray();
            ((JListSelection)c).sourceList.getSelectionModel().clearSelection();
            ((JListSelection)c).targetList.getSelectionModel().clearSelection();
            ((JListSelection)c).sourceModel.clear();
            while (!((JListSelection)c).targetModel.isEmpty()) {
                ((JListSelection)c).sourceModel.addElement(((JListSelection)c).targetModel.remove(0));
            }
            while (!items.isEmpty()) {
                ((JListSelection)c).targetModel.addElement(items.remove(0));
            }
            JLists.setSelectionIndexStream(((JListSelection)c).targetList.getSelectionModel(), IntStream.of(sourceSelection));
            JLists.setSelectionIndexStream(((JListSelection)c).sourceList.getSelectionModel(), IntStream.of(targetSelection));
        }

        @Override
        public boolean isEnabled(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return !((JListSelection)c).sourceModel.isEmpty() || !((JListSelection)c).targetModel.isEmpty();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<T> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            JCommand.ActionAdapter result = super.toAction(c);
            JListSelection.addListDataListener(result, ((JListSelection)c).sourceList);
            JListSelection.addListDataListener(result, ((JListSelection)c).targetList);
            return result;
        }
    }

    private static final class ApplyHorizontalCommand
    extends JCommand<JListSelection<?>> {
        private ApplyHorizontalCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<?> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            c.setOrientation(c.getOrientation() != 0 ? 0 : 1);
        }

        @Override
        public boolean isSelected(@NonNull JListSelection<?> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return c.getOrientation() == 0;
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<?> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return super.toAction(c).withWeakPropertyChangeListener(c, JListSelection.ORIENTATION_PROPERTY);
        }
    }

    private static final class ApplyVerticalCommand
    extends JCommand<JListSelection<?>> {
        private ApplyVerticalCommand() {
        }

        @Override
        public void execute(@NonNull JListSelection<?> c) throws Exception {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            c.setOrientation(c.getOrientation() != 1 ? 1 : 0);
        }

        @Override
        public boolean isSelected(@NonNull JListSelection<?> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return c.getOrientation() == 1;
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull JListSelection<?> c) {
            if (c == null) {
                throw new NullPointerException("c is marked non-null but is null");
            }
            return super.toAction(c).withWeakPropertyChangeListener(c, JListSelection.ORIENTATION_PROPERTY);
        }
    }

    private static final class CustomTransferHandler
    extends TransferHandler {
        private static final LocalDataTransfer<JList> LIST = LocalDataTransfer.of(JList.class);
        @NonNull
        private final JList<?> sourceList;
        @NonNull
        private final JList<?> targetList;

        private boolean isValidComponent(Component c) {
            return c == this.sourceList || c == this.targetList;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop() && LIST.canImport(support) && this.isValidComponent(support.getComponent()) && LIST.getData(support).map(this::isValidComponent).orElse(false) != false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            LIST.getData(support).ifPresent(source -> this.importData((JList<?>)source, (JList)support.getComponent(), (JList.DropLocation)support.getDropLocation()));
            return true;
        }

        private void importData(JList<?> from, JList<?> to, JList.DropLocation dl) {
            int dropIndex = dl.getIndex();
            int[] selection = JLists.getSelectionIndexStream(from.getSelectionModel()).toArray();
            if (from == to && selection[0] < dropIndex) {
                dropIndex -= selection.length;
            }
            JLists.move((DefaultListModel)from.getModel(), (DefaultListModel)to.getModel(), selection, dropIndex);
            to.getSelectionModel().setSelectionInterval(dropIndex, dropIndex + selection.length - 1);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return LIST.createTransferable((JList)c);
        }

        @Generated
        public CustomTransferHandler(@NonNull JList<?> sourceList, @NonNull JList<?> targetList) {
            if (sourceList == null) {
                throw new NullPointerException("sourceList is marked non-null but is null");
            }
            if (targetList == null) {
                throw new NullPointerException("targetList is marked non-null but is null");
            }
            this.sourceList = sourceList;
            this.targetList = targetList;
        }
    }
}

