/*
 * Decompiled with CFR 0.152.
 */
package internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColorIcon
implements Icon {
    private final Color color;
    private final int size;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.color != null) {
            Color savedColor = g.getColor();
            g.setColor(c.getForeground());
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(this.color);
            g.fillRect(x + 1, y + 1, this.getIconWidth() - 1, this.getIconHeight() - 1);
            g.setColor(savedColor);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Generated
    private ColorIcon(Color color, int size) {
        this.color = color;
        this.size = size;
    }

    @Generated
    public static @NonNull ColorIcon of(Color color, int size) {
        return new ColorIcon(color, size);
    }
}

